package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface AuthProviderConfigFluent<A extends AuthProviderConfigFluent<A>> extends Fluent<A>{


    public A addToConfig(String key,String value);
    public A addToConfig(Map<String,String> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,String> map);
    public Map<String,String> getConfig();
    public A withConfig(Map<String,String> config);
    public String getName();
    public A withName(String name);



}
