package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ContainerStateFluent<A extends ContainerStateFluent<A>> extends Fluent<A>{


    public ContainerStateRunning getRunning();
    public A withRunning(ContainerStateRunning running);
    public ContainerStateFluent.RunningNested<A> withNewRunning();
    public ContainerStateFluent.RunningNested<A> withNewRunningLike(ContainerStateRunning item);
    public ContainerStateFluent.RunningNested<A> editRunning();
    public A withNewRunning(String startedAt);
    public ContainerStateTerminated getTerminated();
    public A withTerminated(ContainerStateTerminated terminated);
    public ContainerStateFluent.TerminatedNested<A> withNewTerminated();
    public ContainerStateFluent.TerminatedNested<A> withNewTerminatedLike(ContainerStateTerminated item);
    public ContainerStateFluent.TerminatedNested<A> editTerminated();
    public ContainerStateWaiting getWaiting();
    public A withWaiting(ContainerStateWaiting waiting);
    public ContainerStateFluent.WaitingNested<A> withNewWaiting();
    public ContainerStateFluent.WaitingNested<A> withNewWaitingLike(ContainerStateWaiting item);
    public ContainerStateFluent.WaitingNested<A> editWaiting();
    public A withNewWaiting(String message,String reason);

    public interface RunningNested<N> extends Nested<N>,ContainerStateRunningFluent<ContainerStateFluent.RunningNested<N>>{

        
    public N and();    public N endRunning();
}
    public interface TerminatedNested<N> extends Nested<N>,ContainerStateTerminatedFluent<ContainerStateFluent.TerminatedNested<N>>{

        
    public N endTerminated();    public N and();
}
    public interface WaitingNested<N> extends Nested<N>,ContainerStateWaitingFluent<ContainerStateFluent.WaitingNested<N>>{

        
    public N and();    public N endWaiting();
}


}
