package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EventFluent<A extends EventFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Integer getCount();
    public A withCount(Integer count);
    public String getFirstTimestamp();
    public A withFirstTimestamp(String firstTimestamp);
    public ObjectReference getInvolvedObject();
    public A withInvolvedObject(ObjectReference involvedObject);
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObject();
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(ObjectReference item);
    public EventFluent.InvolvedObjectNested<A> editInvolvedObject();
    public String getKind();
    public A withKind(String kind);
    public String getLastTimestamp();
    public A withLastTimestamp(String lastTimestamp);
    public String getMessage();
    public A withMessage(String message);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public EventFluent.MetadataNested<A> withNewMetadata();
    public EventFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public EventFluent.MetadataNested<A> editMetadata();
    public String getReason();
    public A withReason(String reason);
    public EventSource getSource();
    public A withSource(EventSource source);
    public EventFluent.SourceNested<A> withNewSource();
    public EventFluent.SourceNested<A> withNewSourceLike(EventSource item);
    public EventFluent.SourceNested<A> editSource();
    public A withNewSource(String component,String host);
    public String getType();
    public A withType(String type);

    public interface InvolvedObjectNested<N> extends Nested<N>,ObjectReferenceFluent<EventFluent.InvolvedObjectNested<N>>{

        
    public N and();    public N endInvolvedObject();
}
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<EventFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SourceNested<N> extends Nested<N>,EventSourceFluent<EventFluent.SourceNested<N>>{

        
    public N and();    public N endSource();
}


}
