package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Integer;
import java.lang.Boolean;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface FCVolumeSourceFluent<A extends FCVolumeSourceFluent<A>> extends Fluent<A>{


    public String getFsType();
    public A withFsType(String fsType);
    public Integer getLun();
    public A withLun(Integer lun);
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public A addToTargetWWNs(String... items);
    public A removeFromTargetWWNs(String... items);
    public List<String> getTargetWWNs();
    public A withTargetWWNs(List<String> targetWWNs);
    public A withTargetWWNs(String... targetWWNs);



}
