package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class LimitRangeSpecFluentImpl<A extends LimitRangeSpecFluent<A>> extends BaseFluent<A> implements LimitRangeSpecFluent<A>{

    private List<VisitableBuilder<? extends LimitRangeItem,?>> limits =  new ArrayList<VisitableBuilder<? extends LimitRangeItem,?>>();

    public LimitRangeSpecFluentImpl(){
    }
    public LimitRangeSpecFluentImpl(LimitRangeSpec instance){
            this.withLimits(instance.getLimits()); 
    }

    public A addToLimits(LimitRangeItem... items){
            for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.add(builder);this.limits.add(builder);} return (A)this;
    }

    public A removeFromLimits(LimitRangeItem... items){
            for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.remove(builder);this.limits.remove(builder);} return (A)this;
    }

    public List<LimitRangeItem> getLimits(){
            return build(limits);
    }

    public A withLimits(List<LimitRangeItem> limits){
            this.limits.clear();
            if (limits != null) {for (LimitRangeItem item : limits){this.addToLimits(item);}} return (A) this;
    }

    public A withLimits(LimitRangeItem... limits){
            this.limits.clear(); if (limits != null) {for (LimitRangeItem item :limits){ this.addToLimits(item);}} return (A) this;
    }

    public LimitRangeSpecFluent.LimitsNested<A> addNewLimit(){
            return new LimitsNestedImpl();
    }

    public LimitRangeSpecFluent.LimitsNested<A> addNewLimitLike(LimitRangeItem item){
            return new LimitsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LimitRangeSpecFluentImpl that = (LimitRangeSpecFluentImpl) o;
            if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
            return true;
    }


    public class LimitsNestedImpl<N> extends LimitRangeItemFluentImpl<LimitRangeSpecFluent.LimitsNested<N>> implements LimitRangeSpecFluent.LimitsNested<N>,Nested<N>{

            private final LimitRangeItemBuilder builder;
    
            LimitsNestedImpl(){
                    this.builder = new LimitRangeItemBuilder(this);
            }
            LimitsNestedImpl(LimitRangeItem item){
                    this.builder = new LimitRangeItemBuilder(this, item);
            }
    
    public N and(){
            return (N) LimitRangeSpecFluentImpl.this.addToLimits(builder.build());
    }
    public N endLimit(){
            return and();
    }

}


}
