package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ReplicationControllerFluent<A extends ReplicationControllerFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ReplicationControllerFluent.MetadataNested<A> withNewMetadata();
    public ReplicationControllerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ReplicationControllerFluent.MetadataNested<A> editMetadata();
    public ReplicationControllerSpec getSpec();
    public A withSpec(ReplicationControllerSpec spec);
    public ReplicationControllerFluent.SpecNested<A> withNewSpec();
    public ReplicationControllerFluent.SpecNested<A> withNewSpecLike(ReplicationControllerSpec item);
    public ReplicationControllerFluent.SpecNested<A> editSpec();
    public ReplicationControllerStatus getStatus();
    public A withStatus(ReplicationControllerStatus status);
    public ReplicationControllerFluent.StatusNested<A> withNewStatus();
    public ReplicationControllerFluent.StatusNested<A> withNewStatusLike(ReplicationControllerStatus item);
    public ReplicationControllerFluent.StatusNested<A> editStatus();
    public A withNewStatus(Integer fullyLabeledReplicas,Long observedGeneration,Integer replicas);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ReplicationControllerFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ReplicationControllerSpecFluent<ReplicationControllerFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,ReplicationControllerStatusFluent<ReplicationControllerFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
