package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ServiceListFluent<A extends ServiceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Service... items);
    public A removeFromItems(Service... items);
    public List<Service> getItems();
    public A withItems(List<Service> items);
    public A withItems(Service... items);
    public ServiceListFluent.ItemsNested<A> addNewItem();
    public ServiceListFluent.ItemsNested<A> addNewItemLike(Service item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ServiceListFluent.MetadataNested<A> withNewMetadata();
    public ServiceListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ServiceListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ServiceFluent<ServiceListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ServiceListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
