package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Integer;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface StatusFluent<A extends StatusFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Integer getCode();
    public A withCode(Integer code);
    public StatusDetails getDetails();
    public A withDetails(StatusDetails details);
    public StatusFluent.DetailsNested<A> withNewDetails();
    public StatusFluent.DetailsNested<A> withNewDetailsLike(StatusDetails item);
    public StatusFluent.DetailsNested<A> editDetails();
    public String getKind();
    public A withKind(String kind);
    public String getMessage();
    public A withMessage(String message);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public StatusFluent.MetadataNested<A> withNewMetadata();
    public StatusFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public StatusFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);
    public String getReason();
    public A withReason(String reason);
    public String getStatus();
    public A withStatus(String status);

    public interface DetailsNested<N> extends Nested<N>,StatusDetailsFluent<StatusFluent.DetailsNested<N>>{

        
    public N and();    public N endDetails();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<StatusFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
