package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class StatusFluentImpl<A extends StatusFluent<A>> extends BaseFluent<A> implements StatusFluent<A>{

    private String apiVersion;
    private Integer code;
    private VisitableBuilder<? extends StatusDetails,?> details;
    private String kind;
    private String message;
    private VisitableBuilder<? extends ListMeta,?> metadata;
    private String reason;
    private String status;

    public StatusFluentImpl(){
    }
    public StatusFluentImpl(Status instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withCode(instance.getCode()); 
            this.withDetails(instance.getDetails()); 
            this.withKind(instance.getKind()); 
            this.withMessage(instance.getMessage()); 
            this.withMetadata(instance.getMetadata()); 
            this.withReason(instance.getReason()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Integer getCode(){
            return this.code;
    }

    public A withCode(Integer code){
            this.code=code; return (A) this;
    }

    public StatusDetails getDetails(){
            return this.details!=null?this.details.build():null;
    }

    public A withDetails(StatusDetails details){
            if (details!=null){ this.details= new StatusDetailsBuilder(details); _visitables.add(this.details);} return (A) this;
    }

    public StatusFluent.DetailsNested<A> withNewDetails(){
            return new DetailsNestedImpl();
    }

    public StatusFluent.DetailsNested<A> withNewDetailsLike(StatusDetails item){
            return new DetailsNestedImpl(item);
    }

    public StatusFluent.DetailsNested<A> editDetails(){
            return withNewDetailsLike(getDetails());
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public StatusFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public StatusFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public StatusFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatusFluentImpl that = (StatusFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (code != null ? !code.equals(that.code) :that.code != null) return false;
            if (details != null ? !details.equals(that.details) :that.details != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class DetailsNestedImpl<N> extends StatusDetailsFluentImpl<StatusFluent.DetailsNested<N>> implements StatusFluent.DetailsNested<N>,Nested<N>{

            private final StatusDetailsBuilder builder;
    
            DetailsNestedImpl(){
                    this.builder = new StatusDetailsBuilder(this);
            }
            DetailsNestedImpl(StatusDetails item){
                    this.builder = new StatusDetailsBuilder(this, item);
            }
    
    public N and(){
            return (N) StatusFluentImpl.this.withDetails(builder.build());
    }
    public N endDetails(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<StatusFluent.MetadataNested<N>> implements StatusFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) StatusFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
