package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;

public class WatchEventFluentImpl<A extends WatchEventFluent<A>> extends BaseFluent<A> implements WatchEventFluent<A>{

    private KubernetesResource object;
    private String type;

    public WatchEventFluentImpl(){
    }
    public WatchEventFluentImpl(WatchEvent instance){
            this.withObject(instance.getObject()); 
            this.withType(instance.getType()); 
    }

    public KubernetesResource getObject(){
            return this.object;
    }

    public A withObject(KubernetesResource object){
            this.object=object; return (A) this;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            WatchEventFluentImpl that = (WatchEventFluentImpl) o;
            if (object != null &&object != this ? !object.equals(that.object) :that.object != null &&object != this ) return false;

            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }




}
