package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public class DaemonSetSpecFluentImpl<A extends DaemonSetSpecFluent<A>> extends BaseFluent<A> implements DaemonSetSpecFluent<A>{

    private VisitableBuilder<? extends LabelSelector,?> selector;
    private VisitableBuilder<? extends PodTemplateSpec,?> template;

    public DaemonSetSpecFluentImpl(){
    }
    public DaemonSetSpecFluentImpl(DaemonSetSpec instance){
            this.withSelector(instance.getSelector()); 
            this.withTemplate(instance.getTemplate()); 
    }

    public LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector){
            if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public DaemonSetSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public DaemonSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public DaemonSetSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template){
            if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public DaemonSetSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public DaemonSetSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonSetSpecFluentImpl that = (DaemonSetSpecFluentImpl) o;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<DaemonSetSpecFluent.SelectorNested<N>> implements DaemonSetSpecFluent.SelectorNested<N>,Nested<N>{

            private final LabelSelectorBuilder builder;
    
            SelectorNestedImpl(){
                    this.builder = new LabelSelectorBuilder(this);
            }
            SelectorNestedImpl(LabelSelector item){
                    this.builder = new LabelSelectorBuilder(this, item);
            }
    
    public N endSelector(){
            return and();
    }
    public N and(){
            return (N) DaemonSetSpecFluentImpl.this.withSelector(builder.build());
    }

}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<DaemonSetSpecFluent.TemplateNested<N>> implements DaemonSetSpecFluent.TemplateNested<N>,Nested<N>{

            private final PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(){
                    this.builder = new PodTemplateSpecBuilder(this);
            }
            TemplateNestedImpl(PodTemplateSpec item){
                    this.builder = new PodTemplateSpecBuilder(this, item);
            }
    
    public N endTemplate(){
            return and();
    }
    public N and(){
            return (N) DaemonSetSpecFluentImpl.this.withTemplate(builder.build());
    }

}


}
