package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface BuildStrategyFluent<A extends BuildStrategyFluent<A>> extends Fluent<A>{


    public CustomBuildStrategy getCustomStrategy();
    public A withCustomStrategy(CustomBuildStrategy customStrategy);
    public BuildStrategyFluent.CustomStrategyNested<A> withNewCustomStrategy();
    public BuildStrategyFluent.CustomStrategyNested<A> withNewCustomStrategyLike(CustomBuildStrategy item);
    public BuildStrategyFluent.CustomStrategyNested<A> editCustomStrategy();
    public DockerBuildStrategy getDockerStrategy();
    public A withDockerStrategy(DockerBuildStrategy dockerStrategy);
    public BuildStrategyFluent.DockerStrategyNested<A> withNewDockerStrategy();
    public BuildStrategyFluent.DockerStrategyNested<A> withNewDockerStrategyLike(DockerBuildStrategy item);
    public BuildStrategyFluent.DockerStrategyNested<A> editDockerStrategy();
    public JenkinsPipelineBuildStrategy getJenkinsPipelineStrategy();
    public A withJenkinsPipelineStrategy(JenkinsPipelineBuildStrategy jenkinsPipelineStrategy);
    public BuildStrategyFluent.JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategy();
    public BuildStrategyFluent.JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategyLike(JenkinsPipelineBuildStrategy item);
    public BuildStrategyFluent.JenkinsPipelineStrategyNested<A> editJenkinsPipelineStrategy();
    public A withNewJenkinsPipelineStrategy(String jenkinsfile,String jenkinsfilePath);
    public SourceBuildStrategy getSourceStrategy();
    public A withSourceStrategy(SourceBuildStrategy sourceStrategy);
    public BuildStrategyFluent.SourceStrategyNested<A> withNewSourceStrategy();
    public BuildStrategyFluent.SourceStrategyNested<A> withNewSourceStrategyLike(SourceBuildStrategy item);
    public BuildStrategyFluent.SourceStrategyNested<A> editSourceStrategy();
    public String getType();
    public A withType(String type);

    public interface CustomStrategyNested<N> extends Nested<N>,CustomBuildStrategyFluent<BuildStrategyFluent.CustomStrategyNested<N>>{

        
    public N endCustomStrategy();    public N and();
}
    public interface DockerStrategyNested<N> extends Nested<N>,DockerBuildStrategyFluent<BuildStrategyFluent.DockerStrategyNested<N>>{

        
    public N and();    public N endDockerStrategy();
}
    public interface JenkinsPipelineStrategyNested<N> extends Nested<N>,JenkinsPipelineBuildStrategyFluent<BuildStrategyFluent.JenkinsPipelineStrategyNested<N>>{

        
    public N endJenkinsPipelineStrategy();    public N and();
}
    public interface SourceStrategyNested<N> extends Nested<N>,SourceBuildStrategyFluent<BuildStrategyFluent.SourceStrategyNested<N>>{

        
    public N and();    public N endSourceStrategy();
}


}
