package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface ClusterPolicyListFluent<A extends ClusterPolicyListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ClusterPolicy... items);
    public A removeFromItems(ClusterPolicy... items);
    public List<ClusterPolicy> getItems();
    public A withItems(List<ClusterPolicy> items);
    public A withItems(ClusterPolicy... items);
    public ClusterPolicyListFluent.ItemsNested<A> addNewItem();
    public ClusterPolicyListFluent.ItemsNested<A> addNewItemLike(ClusterPolicy item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ClusterPolicyListFluent.MetadataNested<A> withNewMetadata();
    public ClusterPolicyListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ClusterPolicyListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ClusterPolicyFluent<ClusterPolicyListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ClusterPolicyListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
