package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface IdentityFluent<A extends IdentityFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToExtra(String key,String value);
    public A addToExtra(Map<String,String> map);
    public A removeFromExtra(String key);
    public A removeFromExtra(Map<String,String> map);
    public Map<String,String> getExtra();
    public A withExtra(Map<String,String> extra);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public IdentityFluent.MetadataNested<A> withNewMetadata();
    public IdentityFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public IdentityFluent.MetadataNested<A> editMetadata();
    public String getProviderName();
    public A withProviderName(String providerName);
    public String getProviderUserName();
    public A withProviderUserName(String providerUserName);
    public ObjectReference getUser();
    public A withUser(ObjectReference user);
    public IdentityFluent.UserNested<A> withNewUser();
    public IdentityFluent.UserNested<A> withNewUserLike(ObjectReference item);
    public IdentityFluent.UserNested<A> editUser();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<IdentityFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface UserNested<N> extends Nested<N>,ObjectReferenceFluent<IdentityFluent.UserNested<N>>{

        
    public N and();    public N endUser();
}


}
