package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class PolicyBuilder extends PolicyFluentImpl<PolicyBuilder> implements VisitableBuilder<Policy,PolicyBuilder>{

    PolicyFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyBuilder(){
            this(true);
    }
    public PolicyBuilder(Boolean validationEnabled){
            this(new Policy(), validationEnabled);
    }
    public PolicyBuilder(PolicyFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyBuilder(PolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Policy(), validationEnabled);
    }
    public PolicyBuilder(PolicyFluent<?> fluent,Policy instance){
            this(fluent, instance, true);
    }
    public PolicyBuilder(PolicyFluent<?> fluent,Policy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRoles(instance.getRoles()); 
            this.validationEnabled = validationEnabled; 
    }
    public PolicyBuilder(Policy instance){
            this(instance,true);
    }
    public PolicyBuilder(Policy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoles(instance.getRoles()); 
            this.validationEnabled = validationEnabled; 
    }

    public Policy build(){
            Policy buildable = new Policy(fluent.getApiVersion(),fluent.getKind(),fluent.getLastModified(),fluent.getMetadata(),fluent.getRoles());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyBuilder that = (PolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
