package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface PolicyListFluent<A extends PolicyListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Policy... items);
    public A removeFromItems(Policy... items);
    public List<Policy> getItems();
    public A withItems(List<Policy> items);
    public A withItems(Policy... items);
    public PolicyListFluent.ItemsNested<A> addNewItem();
    public PolicyListFluent.ItemsNested<A> addNewItemLike(Policy item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PolicyListFluent.MetadataNested<A> withNewMetadata();
    public PolicyListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PolicyListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,PolicyFluent<PolicyListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<PolicyListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
