package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public interface SecretBuildSourceFluent<A extends SecretBuildSourceFluent<A>> extends Fluent<A>{


    public String getDestinationDir();
    public A withDestinationDir(String destinationDir);
    public LocalObjectReference getSecret();
    public A withSecret(LocalObjectReference secret);
    public SecretBuildSourceFluent.SecretNested<A> withNewSecret();
    public SecretBuildSourceFluent.SecretNested<A> withNewSecretLike(LocalObjectReference item);
    public SecretBuildSourceFluent.SecretNested<A> editSecret();
    public A withNewSecret(String name);

    public interface SecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<SecretBuildSourceFluent.SecretNested<N>>{

        
    public N and();    public N endSecret();
}


}
