package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.NotNull;
import java.util.Map;
import javax.validation.Valid;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.extensions.Scale;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.Binding;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LimitRangeFluentImpl;
import io.fabric8.kubernetes.api.model.LimitRangeBuilder;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluentImpl;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluentImpl;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluentImpl;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ScaleBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateBuilder;
import io.fabric8.kubernetes.api.model.EventFluentImpl;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluentImpl;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.ComponentStatusFluentImpl;
import io.fabric8.kubernetes.api.model.ComponentStatusBuilder;
import io.fabric8.kubernetes.api.model.BindingFluentImpl;
import io.fabric8.kubernetes.api.model.BindingBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.SecretFluentImpl;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.NodeFluentImpl;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;

public class TemplateFluentImpl<A extends TemplateFluent<A>> extends BaseFluent<A> implements TemplateFluent<A>{

    private String apiVersion;
    private String kind;
    private Map<String,String> labels = new LinkedHashMap<String,String>();
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private List<VisitableBuilder<? extends HasMetadata,?>> objects =  new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();
    private List<VisitableBuilder<? extends Parameter,?>> parameters =  new ArrayList<VisitableBuilder<? extends Parameter,?>>();

    public TemplateFluentImpl(){
    }
    public TemplateFluentImpl(Template instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLabels(instance.getLabels()); 
            this.withMetadata(instance.getMetadata()); 
            this.withObjects(instance.getObjects()); 
            this.withParameters(instance.getParameters()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public A addToLabels(String key,String value){
            if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(key != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.labels.remove(key);}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.labels;
    }

    public A withLabels(Map<String,String> labels){
            this.labels.clear();
            if (labels != null) {this.labels.putAll(labels);} return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public TemplateFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public TemplateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public TemplateFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A addToObjects(HasMetadata... items){
            for (HasMetadata item : items) {if (item instanceof LimitRange){addToLimitRangeObjects((LimitRange)item);}
 else if (item instanceof ThirdPartyResource){addToThirdPartyResourceObjects((ThirdPartyResource)item);}
 else if (item instanceof Job){addToJobObjects((Job)item);}
 else if (item instanceof Project){addToProjectObjects((Project)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof Route){addToRouteObjects((Route)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){addToNamespaceObjects((Namespace)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof Service){addToServiceObjects((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerObjects((ReplicationController)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){addToPolicyBindingObjects((PolicyBinding)item);}
 else if (item instanceof ClusterRole){addToClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof Scale){addToScaleObjects((Scale)item);}
 else if (item instanceof PodTemplate){addToPodTemplateObjects((PodTemplate)item);}
 else if (item instanceof Event){addToEventObjects((Event)item);}
 else if (item instanceof Ingress){addToIngressObjects((Ingress)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){addToRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeObjects((PersistentVolume)item);}
 else if (item instanceof Image){addToImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){addToReplicaSetObjects((ReplicaSet)item);}
 else if (item instanceof Role){addToRoleObjects((Role)item);}
 else if (item instanceof Endpoints){addToEndpointsObjects((Endpoints)item);}
 else if (item instanceof Pod){addToPodObjects((Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapObjects((ConfigMap)item);}
 else if (item instanceof ClusterPolicy){addToClusterPolicyObjects((ClusterPolicy)item);}
 else if (item instanceof DaemonSet){addToDaemonSetObjects((DaemonSet)item);}
 else if (item instanceof Deployment){addToDeploymentObjects((Deployment)item);}
 else if (item instanceof User){addToUserObjects((User)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusObjects((ComponentStatus)item);}
 else if (item instanceof Build){addToBuildObjects((Build)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupObjects((Group)item);}
 else if (item instanceof Policy){addToPolicyObjects((Policy)item);}
 else if (item instanceof ImageSignature){addToImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof Binding){addToBindingObjects((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaObjects((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretObjects((Secret)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){addToClusterPolicyBindingObjects((ClusterPolicyBinding)item);}
 else if (item instanceof Node){addToNodeObjects((Node)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects((ImageStream)item);}
 else if (item instanceof HorizontalPodAutoscaler){addToHorizontalPodAutoscalerObjects((HorizontalPodAutoscaler)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountObjects((ServiceAccount)item);}
 else if (item instanceof Identity){addToIdentityObjects((Identity)item);}
} return (A)this;
    }

    public A removeFromObjects(HasMetadata... items){
            for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeObjects((LimitRange)item);}
 else if (item instanceof ThirdPartyResource){removeFromThirdPartyResourceObjects((ThirdPartyResource)item);}
 else if (item instanceof Job){removeFromJobObjects((Job)item);}
 else if (item instanceof Project){removeFromProjectObjects((Project)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof Route){removeFromRouteObjects((Route)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){removeFromNamespaceObjects((Namespace)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof Service){removeFromServiceObjects((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerObjects((ReplicationController)item);}
 else if (item instanceof ProjectRequest){removeFromProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){removeFromTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){removeFromPolicyBindingObjects((PolicyBinding)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof Scale){removeFromScaleObjects((Scale)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateObjects((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventObjects((Event)item);}
 else if (item instanceof Ingress){removeFromIngressObjects((Ingress)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeObjects((PersistentVolume)item);}
 else if (item instanceof Image){removeFromImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){removeFromReplicaSetObjects((ReplicaSet)item);}
 else if (item instanceof Role){removeFromRoleObjects((Role)item);}
 else if (item instanceof Endpoints){removeFromEndpointsObjects((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodObjects((Pod)item);}
 else if (item instanceof ConfigMap){removeFromConfigMapObjects((ConfigMap)item);}
 else if (item instanceof ClusterPolicy){removeFromClusterPolicyObjects((ClusterPolicy)item);}
 else if (item instanceof DaemonSet){removeFromDaemonSetObjects((DaemonSet)item);}
 else if (item instanceof Deployment){removeFromDeploymentObjects((Deployment)item);}
 else if (item instanceof User){removeFromUserObjects((User)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusObjects((ComponentStatus)item);}
 else if (item instanceof Build){removeFromBuildObjects((Build)item);}
 else if (item instanceof ImageStreamTag){removeFromImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){removeFromGroupObjects((Group)item);}
 else if (item instanceof Policy){removeFromPolicyObjects((Policy)item);}
 else if (item instanceof ImageSignature){removeFromImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof Binding){removeFromBindingObjects((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaObjects((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretObjects((Secret)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){removeFromClusterPolicyBindingObjects((ClusterPolicyBinding)item);}
 else if (item instanceof Node){removeFromNodeObjects((Node)item);}
 else if (item instanceof ImageStream){removeFromImageStreamObjects((ImageStream)item);}
 else if (item instanceof HorizontalPodAutoscaler){removeFromHorizontalPodAutoscalerObjects((HorizontalPodAutoscaler)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountObjects((ServiceAccount)item);}
 else if (item instanceof Identity){removeFromIdentityObjects((Identity)item);}
} return (A)this;
    }

    public List<HasMetadata> getObjects(){
            return build(objects);
    }

    public A withObjects(List<HasMetadata> objects){
            this.objects.clear();
            if (objects != null) {for (HasMetadata item : objects){this.addToObjects(item);}} return (A) this;
    }

    public A withObjects(HasMetadata... objects){
            this.objects.clear(); if (objects != null) {for (HasMetadata item :objects){ this.addToObjects(item);}} return (A) this;
    }

    public A addToLimitRangeObjects(LimitRange... items){
            for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromLimitRangeObjects(LimitRange... items){
            for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.LimitRangeObjectsNested<A> addNewLimitRangeObject(){
            return new LimitRangeObjectsNestedImpl();
    }

    public TemplateFluent.LimitRangeObjectsNested<A> addNewLimitRangeObjectLike(LimitRange item){
            return new LimitRangeObjectsNestedImpl(item);
    }

    public A addToThirdPartyResourceObjects(ThirdPartyResource... items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromThirdPartyResourceObjects(ThirdPartyResource... items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ThirdPartyResourceObjectsNested<A> addNewThirdPartyResourceObject(){
            return new ThirdPartyResourceObjectsNestedImpl();
    }

    public TemplateFluent.ThirdPartyResourceObjectsNested<A> addNewThirdPartyResourceObjectLike(ThirdPartyResource item){
            return new ThirdPartyResourceObjectsNestedImpl(item);
    }

    public A addToJobObjects(Job... items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromJobObjects(Job... items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.JobObjectsNested<A> addNewJobObject(){
            return new JobObjectsNestedImpl();
    }

    public TemplateFluent.JobObjectsNested<A> addNewJobObjectLike(Job item){
            return new JobObjectsNestedImpl(item);
    }

    public A addToProjectObjects(Project... items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromProjectObjects(Project... items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ProjectObjectsNested<A> addNewProjectObject(){
            return new ProjectObjectsNestedImpl();
    }

    public TemplateFluent.ProjectObjectsNested<A> addNewProjectObjectLike(Project item){
            return new ProjectObjectsNestedImpl(item);
    }

    public A addToSecurityContextConstraintsObjects(SecurityContextConstraints... items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromSecurityContextConstraintsObjects(SecurityContextConstraints... items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObject(){
            return new SecurityContextConstraintsObjectsNestedImpl();
    }

    public TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObjectLike(SecurityContextConstraints item){
            return new SecurityContextConstraintsObjectsNestedImpl(item);
    }

    public A addToBuildConfigObjects(BuildConfig... items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromBuildConfigObjects(BuildConfig... items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObject(){
            return new BuildConfigObjectsNestedImpl();
    }

    public TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObjectLike(BuildConfig item){
            return new BuildConfigObjectsNestedImpl(item);
    }

    public A addToRouteObjects(Route... items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromRouteObjects(Route... items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.RouteObjectsNested<A> addNewRouteObject(){
            return new RouteObjectsNestedImpl();
    }

    public TemplateFluent.RouteObjectsNested<A> addNewRouteObjectLike(Route item){
            return new RouteObjectsNestedImpl(item);
    }

    public A addToOAuthAuthorizeTokenObjects(OAuthAuthorizeToken... items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromOAuthAuthorizeTokenObjects(OAuthAuthorizeToken... items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObject(){
            return new OAuthAuthorizeTokenObjectsNestedImpl();
    }

    public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObjectLike(OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenObjectsNestedImpl(item);
    }

    public A addToNamespaceObjects(Namespace... items){
            for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromNamespaceObjects(Namespace... items){
            for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.NamespaceObjectsNested<A> addNewNamespaceObject(){
            return new NamespaceObjectsNestedImpl();
    }

    public TemplateFluent.NamespaceObjectsNested<A> addNewNamespaceObjectLike(Namespace item){
            return new NamespaceObjectsNestedImpl(item);
    }

    public A addToClusterRoleBindingObjects(ClusterRoleBinding... items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromClusterRoleBindingObjects(ClusterRoleBinding... items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObject(){
            return new ClusterRoleBindingObjectsNestedImpl();
    }

    public TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObjectLike(ClusterRoleBinding item){
            return new ClusterRoleBindingObjectsNestedImpl(item);
    }

    public A addToServiceObjects(Service... items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromServiceObjects(Service... items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ServiceObjectsNested<A> addNewServiceObject(){
            return new ServiceObjectsNestedImpl();
    }

    public TemplateFluent.ServiceObjectsNested<A> addNewServiceObjectLike(Service item){
            return new ServiceObjectsNestedImpl(item);
    }

    public A addToReplicationControllerObjects(ReplicationController... items){
            for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromReplicationControllerObjects(ReplicationController... items){
            for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ReplicationControllerObjectsNested<A> addNewReplicationControllerObject(){
            return new ReplicationControllerObjectsNestedImpl();
    }

    public TemplateFluent.ReplicationControllerObjectsNested<A> addNewReplicationControllerObjectLike(ReplicationController item){
            return new ReplicationControllerObjectsNestedImpl(item);
    }

    public A addToProjectRequestObjects(ProjectRequest... items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromProjectRequestObjects(ProjectRequest... items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObject(){
            return new ProjectRequestObjectsNestedImpl();
    }

    public TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObjectLike(ProjectRequest item){
            return new ProjectRequestObjectsNestedImpl(item);
    }

    public A addToTemplateObjects(Template... items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromTemplateObjects(Template... items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.TemplateObjectsNested<A> addNewTemplateObject(){
            return new TemplateObjectsNestedImpl();
    }

    public TemplateFluent.TemplateObjectsNested<A> addNewTemplateObjectLike(Template item){
            return new TemplateObjectsNestedImpl(item);
    }

    public A addToOAuthClientAuthorizationObjects(OAuthClientAuthorization... items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromOAuthClientAuthorizationObjects(OAuthClientAuthorization... items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObject(){
            return new OAuthClientAuthorizationObjectsNestedImpl();
    }

    public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObjectLike(OAuthClientAuthorization item){
            return new OAuthClientAuthorizationObjectsNestedImpl(item);
    }

    public A addToPolicyBindingObjects(PolicyBinding... items){
            for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromPolicyBindingObjects(PolicyBinding... items){
            for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.PolicyBindingObjectsNested<A> addNewPolicyBindingObject(){
            return new PolicyBindingObjectsNestedImpl();
    }

    public TemplateFluent.PolicyBindingObjectsNested<A> addNewPolicyBindingObjectLike(PolicyBinding item){
            return new PolicyBindingObjectsNestedImpl(item);
    }

    public A addToClusterRoleObjects(ClusterRole... items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromClusterRoleObjects(ClusterRole... items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObject(){
            return new ClusterRoleObjectsNestedImpl();
    }

    public TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObjectLike(ClusterRole item){
            return new ClusterRoleObjectsNestedImpl(item);
    }

    public A addToScaleObjects(Scale... items){
            for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromScaleObjects(Scale... items){
            for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ScaleObjectsNested<A> addNewScaleObject(){
            return new ScaleObjectsNestedImpl();
    }

    public TemplateFluent.ScaleObjectsNested<A> addNewScaleObjectLike(Scale item){
            return new ScaleObjectsNestedImpl(item);
    }

    public A addToPodTemplateObjects(PodTemplate... items){
            for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromPodTemplateObjects(PodTemplate... items){
            for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.PodTemplateObjectsNested<A> addNewPodTemplateObject(){
            return new PodTemplateObjectsNestedImpl();
    }

    public TemplateFluent.PodTemplateObjectsNested<A> addNewPodTemplateObjectLike(PodTemplate item){
            return new PodTemplateObjectsNestedImpl(item);
    }

    public A addToEventObjects(Event... items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromEventObjects(Event... items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.EventObjectsNested<A> addNewEventObject(){
            return new EventObjectsNestedImpl();
    }

    public TemplateFluent.EventObjectsNested<A> addNewEventObjectLike(Event item){
            return new EventObjectsNestedImpl(item);
    }

    public A addToIngressObjects(Ingress... items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromIngressObjects(Ingress... items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.IngressObjectsNested<A> addNewIngressObject(){
            return new IngressObjectsNestedImpl();
    }

    public TemplateFluent.IngressObjectsNested<A> addNewIngressObjectLike(Ingress item){
            return new IngressObjectsNestedImpl(item);
    }

    public A addToDeploymentConfigObjects(DeploymentConfig... items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromDeploymentConfigObjects(DeploymentConfig... items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObject(){
            return new DeploymentConfigObjectsNestedImpl();
    }

    public TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObjectLike(DeploymentConfig item){
            return new DeploymentConfigObjectsNestedImpl(item);
    }

    public A addToOAuthAccessTokenObjects(OAuthAccessToken... items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromOAuthAccessTokenObjects(OAuthAccessToken... items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObject(){
            return new OAuthAccessTokenObjectsNestedImpl();
    }

    public TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObjectLike(OAuthAccessToken item){
            return new OAuthAccessTokenObjectsNestedImpl(item);
    }

    public A addToRoleBindingObjects(RoleBinding... items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromRoleBindingObjects(RoleBinding... items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObject(){
            return new RoleBindingObjectsNestedImpl();
    }

    public TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObjectLike(RoleBinding item){
            return new RoleBindingObjectsNestedImpl(item);
    }

    public A addToPersistentVolumeObjects(PersistentVolume... items){
            for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeObjects(PersistentVolume... items){
            for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.PersistentVolumeObjectsNested<A> addNewPersistentVolumeObject(){
            return new PersistentVolumeObjectsNestedImpl();
    }

    public TemplateFluent.PersistentVolumeObjectsNested<A> addNewPersistentVolumeObjectLike(PersistentVolume item){
            return new PersistentVolumeObjectsNestedImpl(item);
    }

    public A addToImageObjects(Image... items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromImageObjects(Image... items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ImageObjectsNested<A> addNewImageObject(){
            return new ImageObjectsNestedImpl();
    }

    public TemplateFluent.ImageObjectsNested<A> addNewImageObjectLike(Image item){
            return new ImageObjectsNestedImpl(item);
    }

    public A addToPersistentVolumeClaimObjects(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeClaimObjects(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject(){
            return new PersistentVolumeClaimObjectsNestedImpl();
    }

    public TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item){
            return new PersistentVolumeClaimObjectsNestedImpl(item);
    }

    public A addToReplicaSetObjects(ReplicaSet... items){
            for (ReplicaSet item : items) {ReplicaSetBuilder builder = new ReplicaSetBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromReplicaSetObjects(ReplicaSet... items){
            for (ReplicaSet item : items) {ReplicaSetBuilder builder = new ReplicaSetBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ReplicaSetObjectsNested<A> addNewReplicaSetObject(){
            return new ReplicaSetObjectsNestedImpl();
    }

    public TemplateFluent.ReplicaSetObjectsNested<A> addNewReplicaSetObjectLike(ReplicaSet item){
            return new ReplicaSetObjectsNestedImpl(item);
    }

    public A addToRoleObjects(Role... items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromRoleObjects(Role... items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.RoleObjectsNested<A> addNewRoleObject(){
            return new RoleObjectsNestedImpl();
    }

    public TemplateFluent.RoleObjectsNested<A> addNewRoleObjectLike(Role item){
            return new RoleObjectsNestedImpl(item);
    }

    public A addToEndpointsObjects(Endpoints... items){
            for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromEndpointsObjects(Endpoints... items){
            for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.EndpointsObjectsNested<A> addNewEndpointsObject(){
            return new EndpointsObjectsNestedImpl();
    }

    public TemplateFluent.EndpointsObjectsNested<A> addNewEndpointsObjectLike(Endpoints item){
            return new EndpointsObjectsNestedImpl(item);
    }

    public A addToPodObjects(Pod... items){
            for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromPodObjects(Pod... items){
            for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.PodObjectsNested<A> addNewPodObject(){
            return new PodObjectsNestedImpl();
    }

    public TemplateFluent.PodObjectsNested<A> addNewPodObjectLike(Pod item){
            return new PodObjectsNestedImpl(item);
    }

    public A addToConfigMapObjects(ConfigMap... items){
            for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromConfigMapObjects(ConfigMap... items){
            for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ConfigMapObjectsNested<A> addNewConfigMapObject(){
            return new ConfigMapObjectsNestedImpl();
    }

    public TemplateFluent.ConfigMapObjectsNested<A> addNewConfigMapObjectLike(ConfigMap item){
            return new ConfigMapObjectsNestedImpl(item);
    }

    public A addToClusterPolicyObjects(ClusterPolicy... items){
            for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromClusterPolicyObjects(ClusterPolicy... items){
            for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ClusterPolicyObjectsNested<A> addNewClusterPolicyObject(){
            return new ClusterPolicyObjectsNestedImpl();
    }

    public TemplateFluent.ClusterPolicyObjectsNested<A> addNewClusterPolicyObjectLike(ClusterPolicy item){
            return new ClusterPolicyObjectsNestedImpl(item);
    }

    public A addToDaemonSetObjects(DaemonSet... items){
            for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromDaemonSetObjects(DaemonSet... items){
            for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.DaemonSetObjectsNested<A> addNewDaemonSetObject(){
            return new DaemonSetObjectsNestedImpl();
    }

    public TemplateFluent.DaemonSetObjectsNested<A> addNewDaemonSetObjectLike(DaemonSet item){
            return new DaemonSetObjectsNestedImpl(item);
    }

    public A addToDeploymentObjects(Deployment... items){
            for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromDeploymentObjects(Deployment... items){
            for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.DeploymentObjectsNested<A> addNewDeploymentObject(){
            return new DeploymentObjectsNestedImpl();
    }

    public TemplateFluent.DeploymentObjectsNested<A> addNewDeploymentObjectLike(Deployment item){
            return new DeploymentObjectsNestedImpl(item);
    }

    public A addToUserObjects(User... items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromUserObjects(User... items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.UserObjectsNested<A> addNewUserObject(){
            return new UserObjectsNestedImpl();
    }

    public TemplateFluent.UserObjectsNested<A> addNewUserObjectLike(User item){
            return new UserObjectsNestedImpl(item);
    }

    public A addToComponentStatusObjects(ComponentStatus... items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromComponentStatusObjects(ComponentStatus... items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ComponentStatusObjectsNested<A> addNewComponentStatusObject(){
            return new ComponentStatusObjectsNestedImpl();
    }

    public TemplateFluent.ComponentStatusObjectsNested<A> addNewComponentStatusObjectLike(ComponentStatus item){
            return new ComponentStatusObjectsNestedImpl(item);
    }

    public A addToBuildObjects(Build... items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromBuildObjects(Build... items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.BuildObjectsNested<A> addNewBuildObject(){
            return new BuildObjectsNestedImpl();
    }

    public TemplateFluent.BuildObjectsNested<A> addNewBuildObjectLike(Build item){
            return new BuildObjectsNestedImpl(item);
    }

    public A addToImageStreamTagObjects(ImageStreamTag... items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromImageStreamTagObjects(ImageStreamTag... items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObject(){
            return new ImageStreamTagObjectsNestedImpl();
    }

    public TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObjectLike(ImageStreamTag item){
            return new ImageStreamTagObjectsNestedImpl(item);
    }

    public A addToGroupObjects(Group... items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromGroupObjects(Group... items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.GroupObjectsNested<A> addNewGroupObject(){
            return new GroupObjectsNestedImpl();
    }

    public TemplateFluent.GroupObjectsNested<A> addNewGroupObjectLike(Group item){
            return new GroupObjectsNestedImpl(item);
    }

    public A addToPolicyObjects(Policy... items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromPolicyObjects(Policy... items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.PolicyObjectsNested<A> addNewPolicyObject(){
            return new PolicyObjectsNestedImpl();
    }

    public TemplateFluent.PolicyObjectsNested<A> addNewPolicyObjectLike(Policy item){
            return new PolicyObjectsNestedImpl(item);
    }

    public A addToImageSignatureObjects(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromImageSignatureObjects(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObject(){
            return new ImageSignatureObjectsNestedImpl();
    }

    public TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObjectLike(ImageSignature item){
            return new ImageSignatureObjectsNestedImpl(item);
    }

    public A addToBindingObjects(Binding... items){
            for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromBindingObjects(Binding... items){
            for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.BindingObjectsNested<A> addNewBindingObject(){
            return new BindingObjectsNestedImpl();
    }

    public TemplateFluent.BindingObjectsNested<A> addNewBindingObjectLike(Binding item){
            return new BindingObjectsNestedImpl(item);
    }

    public A addToResourceQuotaObjects(ResourceQuota... items){
            for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromResourceQuotaObjects(ResourceQuota... items){
            for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ResourceQuotaObjectsNested<A> addNewResourceQuotaObject(){
            return new ResourceQuotaObjectsNestedImpl();
    }

    public TemplateFluent.ResourceQuotaObjectsNested<A> addNewResourceQuotaObjectLike(ResourceQuota item){
            return new ResourceQuotaObjectsNestedImpl(item);
    }

    public A addToSecretObjects(Secret... items){
            for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromSecretObjects(Secret... items){
            for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.SecretObjectsNested<A> addNewSecretObject(){
            return new SecretObjectsNestedImpl();
    }

    public TemplateFluent.SecretObjectsNested<A> addNewSecretObjectLike(Secret item){
            return new SecretObjectsNestedImpl(item);
    }

    public A addToBuildRequestObjects(BuildRequest... items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromBuildRequestObjects(BuildRequest... items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObject(){
            return new BuildRequestObjectsNestedImpl();
    }

    public TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObjectLike(BuildRequest item){
            return new BuildRequestObjectsNestedImpl(item);
    }

    public A addToClusterPolicyBindingObjects(ClusterPolicyBinding... items){
            for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromClusterPolicyBindingObjects(ClusterPolicyBinding... items){
            for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ClusterPolicyBindingObjectsNested<A> addNewClusterPolicyBindingObject(){
            return new ClusterPolicyBindingObjectsNestedImpl();
    }

    public TemplateFluent.ClusterPolicyBindingObjectsNested<A> addNewClusterPolicyBindingObjectLike(ClusterPolicyBinding item){
            return new ClusterPolicyBindingObjectsNestedImpl(item);
    }

    public A addToNodeObjects(Node... items){
            for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromNodeObjects(Node... items){
            for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.NodeObjectsNested<A> addNewNodeObject(){
            return new NodeObjectsNestedImpl();
    }

    public TemplateFluent.NodeObjectsNested<A> addNewNodeObjectLike(Node item){
            return new NodeObjectsNestedImpl(item);
    }

    public A addToImageStreamObjects(ImageStream... items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromImageStreamObjects(ImageStream... items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObject(){
            return new ImageStreamObjectsNestedImpl();
    }

    public TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObjectLike(ImageStream item){
            return new ImageStreamObjectsNestedImpl(item);
    }

    public A addToHorizontalPodAutoscalerObjects(HorizontalPodAutoscaler... items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromHorizontalPodAutoscalerObjects(HorizontalPodAutoscaler... items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.HorizontalPodAutoscalerObjectsNested<A> addNewHorizontalPodAutoscalerObject(){
            return new HorizontalPodAutoscalerObjectsNestedImpl();
    }

    public TemplateFluent.HorizontalPodAutoscalerObjectsNested<A> addNewHorizontalPodAutoscalerObjectLike(HorizontalPodAutoscaler item){
            return new HorizontalPodAutoscalerObjectsNestedImpl(item);
    }

    public A addToOAuthClientObjects(OAuthClient... items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromOAuthClientObjects(OAuthClient... items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObject(){
            return new OAuthClientObjectsNestedImpl();
    }

    public TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObjectLike(OAuthClient item){
            return new OAuthClientObjectsNestedImpl(item);
    }

    public A addToServiceAccountObjects(ServiceAccount... items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromServiceAccountObjects(ServiceAccount... items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.ServiceAccountObjectsNested<A> addNewServiceAccountObject(){
            return new ServiceAccountObjectsNestedImpl();
    }

    public TemplateFluent.ServiceAccountObjectsNested<A> addNewServiceAccountObjectLike(ServiceAccount item){
            return new ServiceAccountObjectsNestedImpl(item);
    }

    public A addToIdentityObjects(Identity... items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromIdentityObjects(Identity... items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.remove(builder);this.objects.remove(builder);} return (A)this;
    }

    public TemplateFluent.IdentityObjectsNested<A> addNewIdentityObject(){
            return new IdentityObjectsNestedImpl();
    }

    public TemplateFluent.IdentityObjectsNested<A> addNewIdentityObjectLike(Identity item){
            return new IdentityObjectsNestedImpl(item);
    }

    public A addToParameters(Parameter... items){
            for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A removeFromParameters(Parameter... items){
            for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.remove(builder);this.parameters.remove(builder);} return (A)this;
    }

    public List<Parameter> getParameters(){
            return build(parameters);
    }

    public A withParameters(List<Parameter> parameters){
            this.parameters.clear();
            if (parameters != null) {for (Parameter item : parameters){this.addToParameters(item);}} return (A) this;
    }

    public A withParameters(Parameter... parameters){
            this.parameters.clear(); if (parameters != null) {for (Parameter item :parameters){ this.addToParameters(item);}} return (A) this;
    }

    public TemplateFluent.ParametersNested<A> addNewParameter(){
            return new ParametersNestedImpl();
    }

    public TemplateFluent.ParametersNested<A> addNewParameterLike(Parameter item){
            return new ParametersNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TemplateFluentImpl that = (TemplateFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (objects != null ? !objects.equals(that.objects) :that.objects != null) return false;
            if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<TemplateFluent.MetadataNested<N>> implements TemplateFluent.MetadataNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class LimitRangeObjectsNestedImpl<N> extends LimitRangeFluentImpl<TemplateFluent.LimitRangeObjectsNested<N>> implements TemplateFluent.LimitRangeObjectsNested<N>,Nested<N>{

            private final LimitRangeBuilder builder;
    
            LimitRangeObjectsNestedImpl(){
                    this.builder = new LimitRangeBuilder(this);
            }
            LimitRangeObjectsNestedImpl(LimitRange item){
                    this.builder = new LimitRangeBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToLimitRangeObjects(builder.build());
    }
    public N endLimitRangeObject(){
            return and();
    }

}
    public class ThirdPartyResourceObjectsNestedImpl<N> extends ThirdPartyResourceFluentImpl<TemplateFluent.ThirdPartyResourceObjectsNested<N>> implements TemplateFluent.ThirdPartyResourceObjectsNested<N>,Nested<N>{

            private final ThirdPartyResourceBuilder builder;
    
            ThirdPartyResourceObjectsNestedImpl(){
                    this.builder = new ThirdPartyResourceBuilder(this);
            }
            ThirdPartyResourceObjectsNestedImpl(ThirdPartyResource item){
                    this.builder = new ThirdPartyResourceBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToThirdPartyResourceObjects(builder.build());
    }
    public N endThirdPartyResourceObject(){
            return and();
    }

}
    public class JobObjectsNestedImpl<N> extends JobFluentImpl<TemplateFluent.JobObjectsNested<N>> implements TemplateFluent.JobObjectsNested<N>,Nested<N>{

            private final JobBuilder builder;
    
            JobObjectsNestedImpl(){
                    this.builder = new JobBuilder(this);
            }
            JobObjectsNestedImpl(Job item){
                    this.builder = new JobBuilder(this, item);
            }
    
    public N endJobObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToJobObjects(builder.build());
    }

}
    public class ProjectObjectsNestedImpl<N> extends ProjectFluentImpl<TemplateFluent.ProjectObjectsNested<N>> implements TemplateFluent.ProjectObjectsNested<N>,Nested<N>{

            private final ProjectBuilder builder;
    
            ProjectObjectsNestedImpl(){
                    this.builder = new ProjectBuilder(this);
            }
            ProjectObjectsNestedImpl(Project item){
                    this.builder = new ProjectBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToProjectObjects(builder.build());
    }
    public N endProjectObject(){
            return and();
    }

}
    public class SecurityContextConstraintsObjectsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<TemplateFluent.SecurityContextConstraintsObjectsNested<N>> implements TemplateFluent.SecurityContextConstraintsObjectsNested<N>,Nested<N>{

            private final SecurityContextConstraintsBuilder builder;
    
            SecurityContextConstraintsObjectsNestedImpl(){
                    this.builder = new SecurityContextConstraintsBuilder(this);
            }
            SecurityContextConstraintsObjectsNestedImpl(SecurityContextConstraints item){
                    this.builder = new SecurityContextConstraintsBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToSecurityContextConstraintsObjects(builder.build());
    }
    public N endSecurityContextConstraintsObject(){
            return and();
    }

}
    public class BuildConfigObjectsNestedImpl<N> extends BuildConfigFluentImpl<TemplateFluent.BuildConfigObjectsNested<N>> implements TemplateFluent.BuildConfigObjectsNested<N>,Nested<N>{

            private final BuildConfigBuilder builder;
    
            BuildConfigObjectsNestedImpl(){
                    this.builder = new BuildConfigBuilder(this);
            }
            BuildConfigObjectsNestedImpl(BuildConfig item){
                    this.builder = new BuildConfigBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToBuildConfigObjects(builder.build());
    }
    public N endBuildConfigObject(){
            return and();
    }

}
    public class RouteObjectsNestedImpl<N> extends RouteFluentImpl<TemplateFluent.RouteObjectsNested<N>> implements TemplateFluent.RouteObjectsNested<N>,Nested<N>{

            private final RouteBuilder builder;
    
            RouteObjectsNestedImpl(){
                    this.builder = new RouteBuilder(this);
            }
            RouteObjectsNestedImpl(Route item){
                    this.builder = new RouteBuilder(this, item);
            }
    
    public N endRouteObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToRouteObjects(builder.build());
    }

}
    public class OAuthAuthorizeTokenObjectsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<TemplateFluent.OAuthAuthorizeTokenObjectsNested<N>> implements TemplateFluent.OAuthAuthorizeTokenObjectsNested<N>,Nested<N>{

            private final OAuthAuthorizeTokenBuilder builder;
    
            OAuthAuthorizeTokenObjectsNestedImpl(){
                    this.builder = new OAuthAuthorizeTokenBuilder(this);
            }
            OAuthAuthorizeTokenObjectsNestedImpl(OAuthAuthorizeToken item){
                    this.builder = new OAuthAuthorizeTokenBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToOAuthAuthorizeTokenObjects(builder.build());
    }
    public N endOAuthAuthorizeTokenObject(){
            return and();
    }

}
    public class NamespaceObjectsNestedImpl<N> extends NamespaceFluentImpl<TemplateFluent.NamespaceObjectsNested<N>> implements TemplateFluent.NamespaceObjectsNested<N>,Nested<N>{

            private final NamespaceBuilder builder;
    
            NamespaceObjectsNestedImpl(){
                    this.builder = new NamespaceBuilder(this);
            }
            NamespaceObjectsNestedImpl(Namespace item){
                    this.builder = new NamespaceBuilder(this, item);
            }
    
    public N endNamespaceObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToNamespaceObjects(builder.build());
    }

}
    public class ClusterRoleBindingObjectsNestedImpl<N> extends ClusterRoleBindingFluentImpl<TemplateFluent.ClusterRoleBindingObjectsNested<N>> implements TemplateFluent.ClusterRoleBindingObjectsNested<N>,Nested<N>{

            private final ClusterRoleBindingBuilder builder;
    
            ClusterRoleBindingObjectsNestedImpl(){
                    this.builder = new ClusterRoleBindingBuilder(this);
            }
            ClusterRoleBindingObjectsNestedImpl(ClusterRoleBinding item){
                    this.builder = new ClusterRoleBindingBuilder(this, item);
            }
    
    public N endClusterRoleBindingObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToClusterRoleBindingObjects(builder.build());
    }

}
    public class ServiceObjectsNestedImpl<N> extends ServiceFluentImpl<TemplateFluent.ServiceObjectsNested<N>> implements TemplateFluent.ServiceObjectsNested<N>,Nested<N>{

            private final ServiceBuilder builder;
    
            ServiceObjectsNestedImpl(Service item){
                    this.builder = new ServiceBuilder(this, item);
            }
            ServiceObjectsNestedImpl(){
                    this.builder = new ServiceBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToServiceObjects(builder.build());
    }
    public N endServiceObject(){
            return and();
    }

}
    public class ReplicationControllerObjectsNestedImpl<N> extends ReplicationControllerFluentImpl<TemplateFluent.ReplicationControllerObjectsNested<N>> implements TemplateFluent.ReplicationControllerObjectsNested<N>,Nested<N>{

            private final ReplicationControllerBuilder builder;
    
            ReplicationControllerObjectsNestedImpl(){
                    this.builder = new ReplicationControllerBuilder(this);
            }
            ReplicationControllerObjectsNestedImpl(ReplicationController item){
                    this.builder = new ReplicationControllerBuilder(this, item);
            }
    
    public N endReplicationControllerObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToReplicationControllerObjects(builder.build());
    }

}
    public class ProjectRequestObjectsNestedImpl<N> extends ProjectRequestFluentImpl<TemplateFluent.ProjectRequestObjectsNested<N>> implements TemplateFluent.ProjectRequestObjectsNested<N>,Nested<N>{

            private final ProjectRequestBuilder builder;
    
            ProjectRequestObjectsNestedImpl(){
                    this.builder = new ProjectRequestBuilder(this);
            }
            ProjectRequestObjectsNestedImpl(ProjectRequest item){
                    this.builder = new ProjectRequestBuilder(this, item);
            }
    
    public N endProjectRequestObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToProjectRequestObjects(builder.build());
    }

}
    public class TemplateObjectsNestedImpl<N> extends TemplateFluentImpl<TemplateFluent.TemplateObjectsNested<N>> implements TemplateFluent.TemplateObjectsNested<N>,Nested<N>{

            private final TemplateBuilder builder;
    
            TemplateObjectsNestedImpl(){
                    this.builder = new TemplateBuilder(this);
            }
            TemplateObjectsNestedImpl(Template item){
                    this.builder = new TemplateBuilder(this, item);
            }
    
    public N endTemplateObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToTemplateObjects(builder.build());
    }

}
    public class OAuthClientAuthorizationObjectsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<TemplateFluent.OAuthClientAuthorizationObjectsNested<N>> implements TemplateFluent.OAuthClientAuthorizationObjectsNested<N>,Nested<N>{

            private final OAuthClientAuthorizationBuilder builder;
    
            OAuthClientAuthorizationObjectsNestedImpl(){
                    this.builder = new OAuthClientAuthorizationBuilder(this);
            }
            OAuthClientAuthorizationObjectsNestedImpl(OAuthClientAuthorization item){
                    this.builder = new OAuthClientAuthorizationBuilder(this, item);
            }
    
    public N endOAuthClientAuthorizationObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToOAuthClientAuthorizationObjects(builder.build());
    }

}
    public class PolicyBindingObjectsNestedImpl<N> extends PolicyBindingFluentImpl<TemplateFluent.PolicyBindingObjectsNested<N>> implements TemplateFluent.PolicyBindingObjectsNested<N>,Nested<N>{

            private final PolicyBindingBuilder builder;
    
            PolicyBindingObjectsNestedImpl(){
                    this.builder = new PolicyBindingBuilder(this);
            }
            PolicyBindingObjectsNestedImpl(PolicyBinding item){
                    this.builder = new PolicyBindingBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToPolicyBindingObjects(builder.build());
    }
    public N endPolicyBindingObject(){
            return and();
    }

}
    public class ClusterRoleObjectsNestedImpl<N> extends ClusterRoleFluentImpl<TemplateFluent.ClusterRoleObjectsNested<N>> implements TemplateFluent.ClusterRoleObjectsNested<N>,Nested<N>{

            private final ClusterRoleBuilder builder;
    
            ClusterRoleObjectsNestedImpl(){
                    this.builder = new ClusterRoleBuilder(this);
            }
            ClusterRoleObjectsNestedImpl(ClusterRole item){
                    this.builder = new ClusterRoleBuilder(this, item);
            }
    
    public N endClusterRoleObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToClusterRoleObjects(builder.build());
    }

}
    public class ScaleObjectsNestedImpl<N> extends ScaleFluentImpl<TemplateFluent.ScaleObjectsNested<N>> implements TemplateFluent.ScaleObjectsNested<N>,Nested<N>{

            private final ScaleBuilder builder;
    
            ScaleObjectsNestedImpl(){
                    this.builder = new ScaleBuilder(this);
            }
            ScaleObjectsNestedImpl(Scale item){
                    this.builder = new ScaleBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToScaleObjects(builder.build());
    }
    public N endScaleObject(){
            return and();
    }

}
    public class PodTemplateObjectsNestedImpl<N> extends PodTemplateFluentImpl<TemplateFluent.PodTemplateObjectsNested<N>> implements TemplateFluent.PodTemplateObjectsNested<N>,Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodTemplateObjectsNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
            PodTemplateObjectsNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
    
    public N endPodTemplateObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToPodTemplateObjects(builder.build());
    }

}
    public class EventObjectsNestedImpl<N> extends EventFluentImpl<TemplateFluent.EventObjectsNested<N>> implements TemplateFluent.EventObjectsNested<N>,Nested<N>{

            private final EventBuilder builder;
    
            EventObjectsNestedImpl(Event item){
                    this.builder = new EventBuilder(this, item);
            }
            EventObjectsNestedImpl(){
                    this.builder = new EventBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToEventObjects(builder.build());
    }
    public N endEventObject(){
            return and();
    }

}
    public class IngressObjectsNestedImpl<N> extends IngressFluentImpl<TemplateFluent.IngressObjectsNested<N>> implements TemplateFluent.IngressObjectsNested<N>,Nested<N>{

            private final IngressBuilder builder;
    
            IngressObjectsNestedImpl(){
                    this.builder = new IngressBuilder(this);
            }
            IngressObjectsNestedImpl(Ingress item){
                    this.builder = new IngressBuilder(this, item);
            }
    
    public N endIngressObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToIngressObjects(builder.build());
    }

}
    public class DeploymentConfigObjectsNestedImpl<N> extends DeploymentConfigFluentImpl<TemplateFluent.DeploymentConfigObjectsNested<N>> implements TemplateFluent.DeploymentConfigObjectsNested<N>,Nested<N>{

            private final DeploymentConfigBuilder builder;
    
            DeploymentConfigObjectsNestedImpl(){
                    this.builder = new DeploymentConfigBuilder(this);
            }
            DeploymentConfigObjectsNestedImpl(DeploymentConfig item){
                    this.builder = new DeploymentConfigBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToDeploymentConfigObjects(builder.build());
    }
    public N endDeploymentConfigObject(){
            return and();
    }

}
    public class OAuthAccessTokenObjectsNestedImpl<N> extends OAuthAccessTokenFluentImpl<TemplateFluent.OAuthAccessTokenObjectsNested<N>> implements TemplateFluent.OAuthAccessTokenObjectsNested<N>,Nested<N>{

            private final OAuthAccessTokenBuilder builder;
    
            OAuthAccessTokenObjectsNestedImpl(){
                    this.builder = new OAuthAccessTokenBuilder(this);
            }
            OAuthAccessTokenObjectsNestedImpl(OAuthAccessToken item){
                    this.builder = new OAuthAccessTokenBuilder(this, item);
            }
    
    public N endOAuthAccessTokenObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToOAuthAccessTokenObjects(builder.build());
    }

}
    public class RoleBindingObjectsNestedImpl<N> extends RoleBindingFluentImpl<TemplateFluent.RoleBindingObjectsNested<N>> implements TemplateFluent.RoleBindingObjectsNested<N>,Nested<N>{

            private final RoleBindingBuilder builder;
    
            RoleBindingObjectsNestedImpl(){
                    this.builder = new RoleBindingBuilder(this);
            }
            RoleBindingObjectsNestedImpl(RoleBinding item){
                    this.builder = new RoleBindingBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToRoleBindingObjects(builder.build());
    }
    public N endRoleBindingObject(){
            return and();
    }

}
    public class PersistentVolumeObjectsNestedImpl<N> extends PersistentVolumeFluentImpl<TemplateFluent.PersistentVolumeObjectsNested<N>> implements TemplateFluent.PersistentVolumeObjectsNested<N>,Nested<N>{

            private final PersistentVolumeBuilder builder;
    
            PersistentVolumeObjectsNestedImpl(){
                    this.builder = new PersistentVolumeBuilder(this);
            }
            PersistentVolumeObjectsNestedImpl(PersistentVolume item){
                    this.builder = new PersistentVolumeBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToPersistentVolumeObjects(builder.build());
    }
    public N endPersistentVolumeObject(){
            return and();
    }

}
    public class ImageObjectsNestedImpl<N> extends ImageFluentImpl<TemplateFluent.ImageObjectsNested<N>> implements TemplateFluent.ImageObjectsNested<N>,Nested<N>{

            private final ImageBuilder builder;
    
            ImageObjectsNestedImpl(){
                    this.builder = new ImageBuilder(this);
            }
            ImageObjectsNestedImpl(Image item){
                    this.builder = new ImageBuilder(this, item);
            }
    
    public N endImageObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToImageObjects(builder.build());
    }

}
    public class PersistentVolumeClaimObjectsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<TemplateFluent.PersistentVolumeClaimObjectsNested<N>> implements TemplateFluent.PersistentVolumeClaimObjectsNested<N>,Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
    
            PersistentVolumeClaimObjectsNestedImpl(){
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
            PersistentVolumeClaimObjectsNestedImpl(PersistentVolumeClaim item){
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
    
    public N endPersistentVolumeClaimObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToPersistentVolumeClaimObjects(builder.build());
    }

}
    public class ReplicaSetObjectsNestedImpl<N> extends ReplicaSetFluentImpl<TemplateFluent.ReplicaSetObjectsNested<N>> implements TemplateFluent.ReplicaSetObjectsNested<N>,Nested<N>{

            private final ReplicaSetBuilder builder;
    
            ReplicaSetObjectsNestedImpl(){
                    this.builder = new ReplicaSetBuilder(this);
            }
            ReplicaSetObjectsNestedImpl(ReplicaSet item){
                    this.builder = new ReplicaSetBuilder(this, item);
            }
    
    public N endReplicaSetObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToReplicaSetObjects(builder.build());
    }

}
    public class RoleObjectsNestedImpl<N> extends RoleFluentImpl<TemplateFluent.RoleObjectsNested<N>> implements TemplateFluent.RoleObjectsNested<N>,Nested<N>{

            private final RoleBuilder builder;
    
            RoleObjectsNestedImpl(){
                    this.builder = new RoleBuilder(this);
            }
            RoleObjectsNestedImpl(Role item){
                    this.builder = new RoleBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToRoleObjects(builder.build());
    }
    public N endRoleObject(){
            return and();
    }

}
    public class EndpointsObjectsNestedImpl<N> extends EndpointsFluentImpl<TemplateFluent.EndpointsObjectsNested<N>> implements TemplateFluent.EndpointsObjectsNested<N>,Nested<N>{

            private final EndpointsBuilder builder;
    
            EndpointsObjectsNestedImpl(){
                    this.builder = new EndpointsBuilder(this);
            }
            EndpointsObjectsNestedImpl(Endpoints item){
                    this.builder = new EndpointsBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToEndpointsObjects(builder.build());
    }
    public N endEndpointsObject(){
            return and();
    }

}
    public class PodObjectsNestedImpl<N> extends PodFluentImpl<TemplateFluent.PodObjectsNested<N>> implements TemplateFluent.PodObjectsNested<N>,Nested<N>{

            private final PodBuilder builder;
    
            PodObjectsNestedImpl(){
                    this.builder = new PodBuilder(this);
            }
            PodObjectsNestedImpl(Pod item){
                    this.builder = new PodBuilder(this, item);
            }
    
    public N endPodObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToPodObjects(builder.build());
    }

}
    public class ConfigMapObjectsNestedImpl<N> extends ConfigMapFluentImpl<TemplateFluent.ConfigMapObjectsNested<N>> implements TemplateFluent.ConfigMapObjectsNested<N>,Nested<N>{

            private final ConfigMapBuilder builder;
    
            ConfigMapObjectsNestedImpl(){
                    this.builder = new ConfigMapBuilder(this);
            }
            ConfigMapObjectsNestedImpl(ConfigMap item){
                    this.builder = new ConfigMapBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToConfigMapObjects(builder.build());
    }
    public N endConfigMapObject(){
            return and();
    }

}
    public class ClusterPolicyObjectsNestedImpl<N> extends ClusterPolicyFluentImpl<TemplateFluent.ClusterPolicyObjectsNested<N>> implements TemplateFluent.ClusterPolicyObjectsNested<N>,Nested<N>{

            private final ClusterPolicyBuilder builder;
    
            ClusterPolicyObjectsNestedImpl(){
                    this.builder = new ClusterPolicyBuilder(this);
            }
            ClusterPolicyObjectsNestedImpl(ClusterPolicy item){
                    this.builder = new ClusterPolicyBuilder(this, item);
            }
    
    public N endClusterPolicyObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToClusterPolicyObjects(builder.build());
    }

}
    public class DaemonSetObjectsNestedImpl<N> extends DaemonSetFluentImpl<TemplateFluent.DaemonSetObjectsNested<N>> implements TemplateFluent.DaemonSetObjectsNested<N>,Nested<N>{

            private final DaemonSetBuilder builder;
    
            DaemonSetObjectsNestedImpl(){
                    this.builder = new DaemonSetBuilder(this);
            }
            DaemonSetObjectsNestedImpl(DaemonSet item){
                    this.builder = new DaemonSetBuilder(this, item);
            }
    
    public N endDaemonSetObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToDaemonSetObjects(builder.build());
    }

}
    public class DeploymentObjectsNestedImpl<N> extends DeploymentFluentImpl<TemplateFluent.DeploymentObjectsNested<N>> implements TemplateFluent.DeploymentObjectsNested<N>,Nested<N>{

            private final DeploymentBuilder builder;
    
            DeploymentObjectsNestedImpl(){
                    this.builder = new DeploymentBuilder(this);
            }
            DeploymentObjectsNestedImpl(Deployment item){
                    this.builder = new DeploymentBuilder(this, item);
            }
    
    public N endDeploymentObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToDeploymentObjects(builder.build());
    }

}
    public class UserObjectsNestedImpl<N> extends UserFluentImpl<TemplateFluent.UserObjectsNested<N>> implements TemplateFluent.UserObjectsNested<N>,Nested<N>{

            private final UserBuilder builder;
    
            UserObjectsNestedImpl(){
                    this.builder = new UserBuilder(this);
            }
            UserObjectsNestedImpl(User item){
                    this.builder = new UserBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToUserObjects(builder.build());
    }
    public N endUserObject(){
            return and();
    }

}
    public class ComponentStatusObjectsNestedImpl<N> extends ComponentStatusFluentImpl<TemplateFluent.ComponentStatusObjectsNested<N>> implements TemplateFluent.ComponentStatusObjectsNested<N>,Nested<N>{

            private final ComponentStatusBuilder builder;
    
            ComponentStatusObjectsNestedImpl(){
                    this.builder = new ComponentStatusBuilder(this);
            }
            ComponentStatusObjectsNestedImpl(ComponentStatus item){
                    this.builder = new ComponentStatusBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToComponentStatusObjects(builder.build());
    }
    public N endComponentStatusObject(){
            return and();
    }

}
    public class BuildObjectsNestedImpl<N> extends BuildFluentImpl<TemplateFluent.BuildObjectsNested<N>> implements TemplateFluent.BuildObjectsNested<N>,Nested<N>{

            private final BuildBuilder builder;
    
            BuildObjectsNestedImpl(Build item){
                    this.builder = new BuildBuilder(this, item);
            }
            BuildObjectsNestedImpl(){
                    this.builder = new BuildBuilder(this);
            }
    
    public N endBuildObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToBuildObjects(builder.build());
    }

}
    public class ImageStreamTagObjectsNestedImpl<N> extends ImageStreamTagFluentImpl<TemplateFluent.ImageStreamTagObjectsNested<N>> implements TemplateFluent.ImageStreamTagObjectsNested<N>,Nested<N>{

            private final ImageStreamTagBuilder builder;
    
            ImageStreamTagObjectsNestedImpl(){
                    this.builder = new ImageStreamTagBuilder(this);
            }
            ImageStreamTagObjectsNestedImpl(ImageStreamTag item){
                    this.builder = new ImageStreamTagBuilder(this, item);
            }
    
    public N endImageStreamTagObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToImageStreamTagObjects(builder.build());
    }

}
    public class GroupObjectsNestedImpl<N> extends GroupFluentImpl<TemplateFluent.GroupObjectsNested<N>> implements TemplateFluent.GroupObjectsNested<N>,Nested<N>{

            private final GroupBuilder builder;
    
            GroupObjectsNestedImpl(){
                    this.builder = new GroupBuilder(this);
            }
            GroupObjectsNestedImpl(Group item){
                    this.builder = new GroupBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToGroupObjects(builder.build());
    }
    public N endGroupObject(){
            return and();
    }

}
    public class PolicyObjectsNestedImpl<N> extends PolicyFluentImpl<TemplateFluent.PolicyObjectsNested<N>> implements TemplateFluent.PolicyObjectsNested<N>,Nested<N>{

            private final PolicyBuilder builder;
    
            PolicyObjectsNestedImpl(){
                    this.builder = new PolicyBuilder(this);
            }
            PolicyObjectsNestedImpl(Policy item){
                    this.builder = new PolicyBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToPolicyObjects(builder.build());
    }
    public N endPolicyObject(){
            return and();
    }

}
    public class ImageSignatureObjectsNestedImpl<N> extends ImageSignatureFluentImpl<TemplateFluent.ImageSignatureObjectsNested<N>> implements TemplateFluent.ImageSignatureObjectsNested<N>,Nested<N>{

            private final ImageSignatureBuilder builder;
    
            ImageSignatureObjectsNestedImpl(){
                    this.builder = new ImageSignatureBuilder(this);
            }
            ImageSignatureObjectsNestedImpl(ImageSignature item){
                    this.builder = new ImageSignatureBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToImageSignatureObjects(builder.build());
    }
    public N endImageSignatureObject(){
            return and();
    }

}
    public class BindingObjectsNestedImpl<N> extends BindingFluentImpl<TemplateFluent.BindingObjectsNested<N>> implements TemplateFluent.BindingObjectsNested<N>,Nested<N>{

            private final BindingBuilder builder;
    
            BindingObjectsNestedImpl(){
                    this.builder = new BindingBuilder(this);
            }
            BindingObjectsNestedImpl(Binding item){
                    this.builder = new BindingBuilder(this, item);
            }
    
    public N endBindingObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToBindingObjects(builder.build());
    }

}
    public class ResourceQuotaObjectsNestedImpl<N> extends ResourceQuotaFluentImpl<TemplateFluent.ResourceQuotaObjectsNested<N>> implements TemplateFluent.ResourceQuotaObjectsNested<N>,Nested<N>{

            private final ResourceQuotaBuilder builder;
    
            ResourceQuotaObjectsNestedImpl(){
                    this.builder = new ResourceQuotaBuilder(this);
            }
            ResourceQuotaObjectsNestedImpl(ResourceQuota item){
                    this.builder = new ResourceQuotaBuilder(this, item);
            }
    
    public N endResourceQuotaObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToResourceQuotaObjects(builder.build());
    }

}
    public class SecretObjectsNestedImpl<N> extends SecretFluentImpl<TemplateFluent.SecretObjectsNested<N>> implements TemplateFluent.SecretObjectsNested<N>,Nested<N>{

            private final SecretBuilder builder;
    
            SecretObjectsNestedImpl(){
                    this.builder = new SecretBuilder(this);
            }
            SecretObjectsNestedImpl(Secret item){
                    this.builder = new SecretBuilder(this, item);
            }
    
    public N endSecretObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToSecretObjects(builder.build());
    }

}
    public class BuildRequestObjectsNestedImpl<N> extends BuildRequestFluentImpl<TemplateFluent.BuildRequestObjectsNested<N>> implements TemplateFluent.BuildRequestObjectsNested<N>,Nested<N>{

            private final BuildRequestBuilder builder;
    
            BuildRequestObjectsNestedImpl(){
                    this.builder = new BuildRequestBuilder(this);
            }
            BuildRequestObjectsNestedImpl(BuildRequest item){
                    this.builder = new BuildRequestBuilder(this, item);
            }
    
    public N endBuildRequestObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToBuildRequestObjects(builder.build());
    }

}
    public class ClusterPolicyBindingObjectsNestedImpl<N> extends ClusterPolicyBindingFluentImpl<TemplateFluent.ClusterPolicyBindingObjectsNested<N>> implements TemplateFluent.ClusterPolicyBindingObjectsNested<N>,Nested<N>{

            private final ClusterPolicyBindingBuilder builder;
    
            ClusterPolicyBindingObjectsNestedImpl(){
                    this.builder = new ClusterPolicyBindingBuilder(this);
            }
            ClusterPolicyBindingObjectsNestedImpl(ClusterPolicyBinding item){
                    this.builder = new ClusterPolicyBindingBuilder(this, item);
            }
    
    public N endClusterPolicyBindingObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToClusterPolicyBindingObjects(builder.build());
    }

}
    public class NodeObjectsNestedImpl<N> extends NodeFluentImpl<TemplateFluent.NodeObjectsNested<N>> implements TemplateFluent.NodeObjectsNested<N>,Nested<N>{

            private final NodeBuilder builder;
    
            NodeObjectsNestedImpl(){
                    this.builder = new NodeBuilder(this);
            }
            NodeObjectsNestedImpl(Node item){
                    this.builder = new NodeBuilder(this, item);
            }
    
    public N endNodeObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToNodeObjects(builder.build());
    }

}
    public class ImageStreamObjectsNestedImpl<N> extends ImageStreamFluentImpl<TemplateFluent.ImageStreamObjectsNested<N>> implements TemplateFluent.ImageStreamObjectsNested<N>,Nested<N>{

            private final ImageStreamBuilder builder;
    
            ImageStreamObjectsNestedImpl(ImageStream item){
                    this.builder = new ImageStreamBuilder(this, item);
            }
            ImageStreamObjectsNestedImpl(){
                    this.builder = new ImageStreamBuilder(this);
            }
    
    public N endImageStreamObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToImageStreamObjects(builder.build());
    }

}
    public class HorizontalPodAutoscalerObjectsNestedImpl<N> extends HorizontalPodAutoscalerFluentImpl<TemplateFluent.HorizontalPodAutoscalerObjectsNested<N>> implements TemplateFluent.HorizontalPodAutoscalerObjectsNested<N>,Nested<N>{

            private final HorizontalPodAutoscalerBuilder builder;
    
            HorizontalPodAutoscalerObjectsNestedImpl(){
                    this.builder = new HorizontalPodAutoscalerBuilder(this);
            }
            HorizontalPodAutoscalerObjectsNestedImpl(HorizontalPodAutoscaler item){
                    this.builder = new HorizontalPodAutoscalerBuilder(this, item);
            }
    
    public N endHorizontalPodAutoscalerObject(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToHorizontalPodAutoscalerObjects(builder.build());
    }

}
    public class OAuthClientObjectsNestedImpl<N> extends OAuthClientFluentImpl<TemplateFluent.OAuthClientObjectsNested<N>> implements TemplateFluent.OAuthClientObjectsNested<N>,Nested<N>{

            private final OAuthClientBuilder builder;
    
            OAuthClientObjectsNestedImpl(){
                    this.builder = new OAuthClientBuilder(this);
            }
            OAuthClientObjectsNestedImpl(OAuthClient item){
                    this.builder = new OAuthClientBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToOAuthClientObjects(builder.build());
    }
    public N endOAuthClientObject(){
            return and();
    }

}
    public class ServiceAccountObjectsNestedImpl<N> extends ServiceAccountFluentImpl<TemplateFluent.ServiceAccountObjectsNested<N>> implements TemplateFluent.ServiceAccountObjectsNested<N>,Nested<N>{

            private final ServiceAccountBuilder builder;
    
            ServiceAccountObjectsNestedImpl(){
                    this.builder = new ServiceAccountBuilder(this);
            }
            ServiceAccountObjectsNestedImpl(ServiceAccount item){
                    this.builder = new ServiceAccountBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToServiceAccountObjects(builder.build());
    }
    public N endServiceAccountObject(){
            return and();
    }

}
    public class IdentityObjectsNestedImpl<N> extends IdentityFluentImpl<TemplateFluent.IdentityObjectsNested<N>> implements TemplateFluent.IdentityObjectsNested<N>,Nested<N>{

            private final IdentityBuilder builder;
    
            IdentityObjectsNestedImpl(){
                    this.builder = new IdentityBuilder(this);
            }
            IdentityObjectsNestedImpl(Identity item){
                    this.builder = new IdentityBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.addToIdentityObjects(builder.build());
    }
    public N endIdentityObject(){
            return and();
    }

}
    public class ParametersNestedImpl<N> extends ParameterFluentImpl<TemplateFluent.ParametersNested<N>> implements TemplateFluent.ParametersNested<N>,Nested<N>{

            private final ParameterBuilder builder;
    
            ParametersNestedImpl(Parameter item){
                    this.builder = new ParameterBuilder(this, item);
            }
            ParametersNestedImpl(){
                    this.builder = new ParameterBuilder(this);
            }
    
    public N endParameter(){
            return and();
    }
    public N and(){
            return (N) TemplateFluentImpl.this.addToParameters(builder.build());
    }

}


}
