package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public interface ServicePortFluent<A extends ServicePortFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Integer getNodePort();
    public A withNodePort(Integer nodePort);
    public Integer getPort();
    public A withPort(Integer port);
    public String getProtocol();
    public A withProtocol(String protocol);
    public IntOrString getTargetPort();
    public A withTargetPort(IntOrString targetPort);
    public ServicePortFluent.TargetPortNested<A> withNewTargetPort();
    public ServicePortFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item);
    public ServicePortFluent.TargetPortNested<A> editTargetPort();
    public A withNewTargetPort(String strVal);
    public A withNewTargetPort(Integer intVal);

    public interface TargetPortNested<N> extends Nested<N>,IntOrStringFluent<ServicePortFluent.TargetPortNested<N>>{

        
    public N endTargetPort();    public N and();
}


}
