package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class DockerConfigBuilder extends DockerConfigFluentImpl<DockerConfigBuilder> implements VisitableBuilder<DockerConfig,DockerConfigBuilder>{

    DockerConfigFluent<?> fluent;
    Boolean validationEnabled;

    public DockerConfigBuilder(){
            this(true);
    }
    public DockerConfigBuilder(Boolean validationEnabled){
            this(new DockerConfig(), validationEnabled);
    }
    public DockerConfigBuilder(DockerConfigFluent<?> fluent){
            this(fluent, true);
    }
    public DockerConfigBuilder(DockerConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DockerConfig(), validationEnabled);
    }
    public DockerConfigBuilder(DockerConfigFluent<?> fluent,DockerConfig instance){
            this(fluent, instance, true);
    }
    public DockerConfigBuilder(DockerConfigFluent<?> fluent,DockerConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttachStderr(instance.getAttachStderr()); 
            fluent.withAttachStdin(instance.getAttachStdin()); 
            fluent.withAttachStdout(instance.getAttachStdout()); 
            fluent.withCmd(instance.getCmd()); 
            fluent.withCpuShares(instance.getCpuShares()); 
            fluent.withCpuset(instance.getCpuset()); 
            fluent.withDns(instance.getDns()); 
            fluent.withDomainname(instance.getDomainname()); 
            fluent.withEntrypoint(instance.getEntrypoint()); 
            fluent.withEnv(instance.getEnv()); 
            fluent.withExposedPorts(instance.getExposedPorts()); 
            fluent.withHostname(instance.getHostname()); 
            fluent.withImage(instance.getImage()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withMemory(instance.getMemory()); 
            fluent.withMemorySwap(instance.getMemorySwap()); 
            fluent.withNetworkDisabled(instance.getNetworkDisabled()); 
            fluent.withOnBuild(instance.getOnBuild()); 
            fluent.withOpenStdin(instance.getOpenStdin()); 
            fluent.withPortSpecs(instance.getPortSpecs()); 
            fluent.withSecurityOpts(instance.getSecurityOpts()); 
            fluent.withStdinOnce(instance.getStdinOnce()); 
            fluent.withTty(instance.getTty()); 
            fluent.withUser(instance.getUser()); 
            fluent.withVolumes(instance.getVolumes()); 
            fluent.withVolumesFrom(instance.getVolumesFrom()); 
            fluent.withWorkingDir(instance.getWorkingDir()); 
            this.validationEnabled = validationEnabled; 
    }
    public DockerConfigBuilder(DockerConfig instance){
            this(instance,true);
    }
    public DockerConfigBuilder(DockerConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttachStderr(instance.getAttachStderr()); 
            this.withAttachStdin(instance.getAttachStdin()); 
            this.withAttachStdout(instance.getAttachStdout()); 
            this.withCmd(instance.getCmd()); 
            this.withCpuShares(instance.getCpuShares()); 
            this.withCpuset(instance.getCpuset()); 
            this.withDns(instance.getDns()); 
            this.withDomainname(instance.getDomainname()); 
            this.withEntrypoint(instance.getEntrypoint()); 
            this.withEnv(instance.getEnv()); 
            this.withExposedPorts(instance.getExposedPorts()); 
            this.withHostname(instance.getHostname()); 
            this.withImage(instance.getImage()); 
            this.withLabels(instance.getLabels()); 
            this.withMemory(instance.getMemory()); 
            this.withMemorySwap(instance.getMemorySwap()); 
            this.withNetworkDisabled(instance.getNetworkDisabled()); 
            this.withOnBuild(instance.getOnBuild()); 
            this.withOpenStdin(instance.getOpenStdin()); 
            this.withPortSpecs(instance.getPortSpecs()); 
            this.withSecurityOpts(instance.getSecurityOpts()); 
            this.withStdinOnce(instance.getStdinOnce()); 
            this.withTty(instance.getTty()); 
            this.withUser(instance.getUser()); 
            this.withVolumes(instance.getVolumes()); 
            this.withVolumesFrom(instance.getVolumesFrom()); 
            this.withWorkingDir(instance.getWorkingDir()); 
            this.validationEnabled = validationEnabled; 
    }

    public DockerConfig build(){
            DockerConfig buildable = new DockerConfig(fluent.isAttachStderr(),fluent.isAttachStdin(),fluent.isAttachStdout(),fluent.getCmd(),fluent.getCpuShares(),fluent.getCpuset(),fluent.getDns(),fluent.getDomainname(),fluent.getEntrypoint(),fluent.getEnv(),fluent.getExposedPorts(),fluent.getHostname(),fluent.getImage(),fluent.getLabels(),fluent.getMemory(),fluent.getMemorySwap(),fluent.isNetworkDisabled(),fluent.getOnBuild(),fluent.isOpenStdin(),fluent.getPortSpecs(),fluent.getSecurityOpts(),fluent.isStdinOnce(),fluent.isTty(),fluent.getUser(),fluent.getVolumes(),fluent.getVolumesFrom(),fluent.getWorkingDir());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerConfigBuilder that = (DockerConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
