package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface ImageChangeCauseFluent<A extends ImageChangeCauseFluent<A>> extends Fluent<A>{


    public ObjectReference getFromRef();
    public A withFromRef(ObjectReference fromRef);
    public ImageChangeCauseFluent.FromRefNested<A> withNewFromRef();
    public ImageChangeCauseFluent.FromRefNested<A> withNewFromRefLike(ObjectReference item);
    public ImageChangeCauseFluent.FromRefNested<A> editFromRef();
    public String getImageID();
    public A withImageID(String imageID);

    public interface FromRefNested<N> extends Nested<N>,ObjectReferenceFluent<ImageChangeCauseFluent.FromRefNested<N>>{

        
    public N and();    public N endFromRef();
}


}
