package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Boolean;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.List;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface DockerConfigFluent<A extends DockerConfigFluent<A>> extends Fluent<A>{


    public Boolean isAttachStderr();
    public A withAttachStderr(Boolean attachStderr);
    public Boolean isAttachStdin();
    public A withAttachStdin(Boolean attachStdin);
    public Boolean isAttachStdout();
    public A withAttachStdout(Boolean attachStdout);
    public A addToCmd(String... items);
    public A removeFromCmd(String... items);
    public List<String> getCmd();
    public A withCmd(List<String> cmd);
    public A withCmd(String... cmd);
    public Long getCpuShares();
    public A withCpuShares(Long cpuShares);
    public String getCpuset();
    public A withCpuset(String cpuset);
    public A addToDns(String... items);
    public A removeFromDns(String... items);
    public List<String> getDns();
    public A withDns(List<String> dns);
    public A withDns(String... dns);
    public String getDomainname();
    public A withDomainname(String domainname);
    public A addToEntrypoint(String... items);
    public A removeFromEntrypoint(String... items);
    public List<String> getEntrypoint();
    public A withEntrypoint(List<String> entrypoint);
    public A withEntrypoint(String... entrypoint);
    public A addToEnv(String... items);
    public A removeFromEnv(String... items);
    public List<String> getEnv();
    public A withEnv(List<String> env);
    public A withEnv(String... env);
    public A addToExposedPorts(String key,Object value);
    public A addToExposedPorts(Map<String,Object> map);
    public A removeFromExposedPorts(String key);
    public A removeFromExposedPorts(Map<String,Object> map);
    public Map<String,Object> getExposedPorts();
    public A withExposedPorts(Map<String,Object> exposedPorts);
    public String getHostname();
    public A withHostname(String hostname);
    public String getImage();
    public A withImage(String image);
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Long getMemory();
    public A withMemory(Long memory);
    public Long getMemorySwap();
    public A withMemorySwap(Long memorySwap);
    public Boolean isNetworkDisabled();
    public A withNetworkDisabled(Boolean networkDisabled);
    public A addToOnBuild(String... items);
    public A removeFromOnBuild(String... items);
    public List<String> getOnBuild();
    public A withOnBuild(List<String> onBuild);
    public A withOnBuild(String... onBuild);
    public Boolean isOpenStdin();
    public A withOpenStdin(Boolean openStdin);
    public A addToPortSpecs(String... items);
    public A removeFromPortSpecs(String... items);
    public List<String> getPortSpecs();
    public A withPortSpecs(List<String> portSpecs);
    public A withPortSpecs(String... portSpecs);
    public A addToSecurityOpts(String... items);
    public A removeFromSecurityOpts(String... items);
    public List<String> getSecurityOpts();
    public A withSecurityOpts(List<String> securityOpts);
    public A withSecurityOpts(String... securityOpts);
    public Boolean isStdinOnce();
    public A withStdinOnce(Boolean stdinOnce);
    public Boolean isTty();
    public A withTty(Boolean tty);
    public String getUser();
    public A withUser(String user);
    public A addToVolumes(String key,Object value);
    public A addToVolumes(Map<String,Object> map);
    public A removeFromVolumes(String key);
    public A removeFromVolumes(Map<String,Object> map);
    public Map<String,Object> getVolumes();
    public A withVolumes(Map<String,Object> volumes);
    public String getVolumesFrom();
    public A withVolumesFrom(String volumesFrom);
    public String getWorkingDir();
    public A withWorkingDir(String workingDir);



}
