
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "Architecture",
    "Author",
    "Comment",
    "Config",
    "Container",
    "ContainerConfig",
    "Created",
    "DockerVersion",
    "Id",
    "Parent",
    "Size"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class DockerImage implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("Architecture")
    private String architecture;
    /**
     * 
     * 
     */
    @JsonProperty("Author")
    private String author;
    /**
     * 
     * 
     */
    @JsonProperty("Comment")
    private String comment;
    /**
     * 
     * 
     */
    @JsonProperty("Config")
    @Valid
    private DockerConfig config;
    /**
     * 
     * 
     */
    @JsonProperty("Container")
    private String container;
    /**
     * 
     * 
     */
    @JsonProperty("ContainerConfig")
    @Valid
    private DockerConfig containerConfig;
    /**
     * 
     * 
     */
    @JsonProperty("Created")
    private String created;
    /**
     * 
     * 
     */
    @JsonProperty("DockerVersion")
    private String dockerVersion;
    /**
     * 
     * 
     */
    @JsonProperty("Id")
    private String id;
    /**
     * 
     * 
     */
    @JsonProperty("Parent")
    private String parent;
    /**
     * 
     * 
     */
    @JsonProperty("Size")
    private Long size;
    /**
     * 
     * (Required)
     * 
     */
    @NotNull
    @JsonProperty("apiVersion")
    private String apiVersion = "image/api";
    /**
     * 
     * (Required)
     * 
     */
    @NotNull
    @JsonProperty("kind")
    private String kind = "DockerImage";
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public DockerImage() {
    }

    /**
     * 
     * @param container
     * @param parent
     * @param containerConfig
     * @param author
     * @param created
     * @param kind
     * @param apiVersion
     * @param dockerVersion
     * @param size
     * @param comment
     * @param id
     * @param config
     * @param architecture
     */
    public DockerImage(String architecture, String author, String comment, DockerConfig config, String container, DockerConfig containerConfig, String created, String dockerVersion, String id, String parent, Long size, String apiVersion, String kind) {
        this.architecture = architecture;
        this.author = author;
        this.comment = comment;
        this.config = config;
        this.container = container;
        this.containerConfig = containerConfig;
        this.created = created;
        this.dockerVersion = dockerVersion;
        this.id = id;
        this.parent = parent;
        this.size = size;
        this.apiVersion = apiVersion;
        this.kind = kind;
    }

    /**
     * 
     * 
     * @return
     *     The architecture
     */
    @JsonProperty("Architecture")
    public String getArchitecture() {
        return architecture;
    }

    /**
     * 
     * 
     * @param architecture
     *     The Architecture
     */
    @JsonProperty("Architecture")
    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    /**
     * 
     * 
     * @return
     *     The author
     */
    @JsonProperty("Author")
    public String getAuthor() {
        return author;
    }

    /**
     * 
     * 
     * @param author
     *     The Author
     */
    @JsonProperty("Author")
    public void setAuthor(String author) {
        this.author = author;
    }

    /**
     * 
     * 
     * @return
     *     The comment
     */
    @JsonProperty("Comment")
    public String getComment() {
        return comment;
    }

    /**
     * 
     * 
     * @param comment
     *     The Comment
     */
    @JsonProperty("Comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    /**
     * 
     * 
     * @return
     *     The config
     */
    @JsonProperty("Config")
    public DockerConfig getConfig() {
        return config;
    }

    /**
     * 
     * 
     * @param config
     *     The Config
     */
    @JsonProperty("Config")
    public void setConfig(DockerConfig config) {
        this.config = config;
    }

    /**
     * 
     * 
     * @return
     *     The container
     */
    @JsonProperty("Container")
    public String getContainer() {
        return container;
    }

    /**
     * 
     * 
     * @param container
     *     The Container
     */
    @JsonProperty("Container")
    public void setContainer(String container) {
        this.container = container;
    }

    /**
     * 
     * 
     * @return
     *     The containerConfig
     */
    @JsonProperty("ContainerConfig")
    public DockerConfig getContainerConfig() {
        return containerConfig;
    }

    /**
     * 
     * 
     * @param containerConfig
     *     The ContainerConfig
     */
    @JsonProperty("ContainerConfig")
    public void setContainerConfig(DockerConfig containerConfig) {
        this.containerConfig = containerConfig;
    }

    /**
     * 
     * 
     * @return
     *     The created
     */
    @JsonProperty("Created")
    public String getCreated() {
        return created;
    }

    /**
     * 
     * 
     * @param created
     *     The Created
     */
    @JsonProperty("Created")
    public void setCreated(String created) {
        this.created = created;
    }

    /**
     * 
     * 
     * @return
     *     The dockerVersion
     */
    @JsonProperty("DockerVersion")
    public String getDockerVersion() {
        return dockerVersion;
    }

    /**
     * 
     * 
     * @param dockerVersion
     *     The DockerVersion
     */
    @JsonProperty("DockerVersion")
    public void setDockerVersion(String dockerVersion) {
        this.dockerVersion = dockerVersion;
    }

    /**
     * 
     * 
     * @return
     *     The id
     */
    @JsonProperty("Id")
    public String getId() {
        return id;
    }

    /**
     * 
     * 
     * @param id
     *     The Id
     */
    @JsonProperty("Id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 
     * 
     * @return
     *     The parent
     */
    @JsonProperty("Parent")
    public String getParent() {
        return parent;
    }

    /**
     * 
     * 
     * @param parent
     *     The Parent
     */
    @JsonProperty("Parent")
    public void setParent(String parent) {
        this.parent = parent;
    }

    /**
     * 
     * 
     * @return
     *     The size
     */
    @JsonProperty("Size")
    public Long getSize() {
        return size;
    }

    /**
     * 
     * 
     * @param size
     *     The Size
     */
    @JsonProperty("Size")
    public void setSize(Long size) {
        this.size = size;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * 
     * (Required)
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
