package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.Long;
import javax.validation.constraints.NotNull;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class DockerImageFluentImpl<A extends DockerImageFluent<A>> extends BaseFluent<A> implements DockerImageFluent<A>{

    private String architecture;
    private String author;
    private String comment;
    private VisitableBuilder<? extends DockerConfig,?> config;
    private String container;
    private VisitableBuilder<? extends DockerConfig,?> containerConfig;
    private String created;
    private String dockerVersion;
    private String id;
    private String parent;
    private Long size;
    private String apiVersion;
    private String kind;

    public DockerImageFluentImpl(){
    }
    public DockerImageFluentImpl(DockerImage instance){
            this.withArchitecture(instance.getArchitecture()); 
            this.withAuthor(instance.getAuthor()); 
            this.withComment(instance.getComment()); 
            this.withConfig(instance.getConfig()); 
            this.withContainer(instance.getContainer()); 
            this.withContainerConfig(instance.getContainerConfig()); 
            this.withCreated(instance.getCreated()); 
            this.withDockerVersion(instance.getDockerVersion()); 
            this.withId(instance.getId()); 
            this.withParent(instance.getParent()); 
            this.withSize(instance.getSize()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
    }

    public String getArchitecture(){
            return this.architecture;
    }

    public A withArchitecture(String architecture){
            this.architecture=architecture; return (A) this;
    }

    public String getAuthor(){
            return this.author;
    }

    public A withAuthor(String author){
            this.author=author; return (A) this;
    }

    public String getComment(){
            return this.comment;
    }

    public A withComment(String comment){
            this.comment=comment; return (A) this;
    }

    public DockerConfig getConfig(){
            return this.config!=null?this.config.build():null;
    }

    public A withConfig(DockerConfig config){
            if (config!=null){ this.config= new DockerConfigBuilder(config); _visitables.add(this.config);} return (A) this;
    }

    public DockerImageFluent.ConfigNested<A> withNewConfig(){
            return new ConfigNestedImpl();
    }

    public DockerImageFluent.ConfigNested<A> withNewConfigLike(DockerConfig item){
            return new ConfigNestedImpl(item);
    }

    public DockerImageFluent.ConfigNested<A> editConfig(){
            return withNewConfigLike(getConfig());
    }

    public String getContainer(){
            return this.container;
    }

    public A withContainer(String container){
            this.container=container; return (A) this;
    }

    public DockerConfig getContainerConfig(){
            return this.containerConfig!=null?this.containerConfig.build():null;
    }

    public A withContainerConfig(DockerConfig containerConfig){
            if (containerConfig!=null){ this.containerConfig= new DockerConfigBuilder(containerConfig); _visitables.add(this.containerConfig);} return (A) this;
    }

    public DockerImageFluent.ContainerConfigNested<A> withNewContainerConfig(){
            return new ContainerConfigNestedImpl();
    }

    public DockerImageFluent.ContainerConfigNested<A> withNewContainerConfigLike(DockerConfig item){
            return new ContainerConfigNestedImpl(item);
    }

    public DockerImageFluent.ContainerConfigNested<A> editContainerConfig(){
            return withNewContainerConfigLike(getContainerConfig());
    }

    public String getCreated(){
            return this.created;
    }

    public A withCreated(String created){
            this.created=created; return (A) this;
    }

    public String getDockerVersion(){
            return this.dockerVersion;
    }

    public A withDockerVersion(String dockerVersion){
            this.dockerVersion=dockerVersion; return (A) this;
    }

    public String getId(){
            return this.id;
    }

    public A withId(String id){
            this.id=id; return (A) this;
    }

    public String getParent(){
            return this.parent;
    }

    public A withParent(String parent){
            this.parent=parent; return (A) this;
    }

    public Long getSize(){
            return this.size;
    }

    public A withSize(Long size){
            this.size=size; return (A) this;
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerImageFluentImpl that = (DockerImageFluentImpl) o;
            if (architecture != null ? !architecture.equals(that.architecture) :that.architecture != null) return false;
            if (author != null ? !author.equals(that.author) :that.author != null) return false;
            if (comment != null ? !comment.equals(that.comment) :that.comment != null) return false;
            if (config != null ? !config.equals(that.config) :that.config != null) return false;
            if (container != null ? !container.equals(that.container) :that.container != null) return false;
            if (containerConfig != null ? !containerConfig.equals(that.containerConfig) :that.containerConfig != null) return false;
            if (created != null ? !created.equals(that.created) :that.created != null) return false;
            if (dockerVersion != null ? !dockerVersion.equals(that.dockerVersion) :that.dockerVersion != null) return false;
            if (id != null ? !id.equals(that.id) :that.id != null) return false;
            if (parent != null ? !parent.equals(that.parent) :that.parent != null) return false;
            if (size != null ? !size.equals(that.size) :that.size != null) return false;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            return true;
    }


    public class ConfigNestedImpl<N> extends DockerConfigFluentImpl<DockerImageFluent.ConfigNested<N>> implements DockerImageFluent.ConfigNested<N>,Nested<N>{

            private final DockerConfigBuilder builder;
    
            ConfigNestedImpl(){
                    this.builder = new DockerConfigBuilder(this);
            }
            ConfigNestedImpl(DockerConfig item){
                    this.builder = new DockerConfigBuilder(this, item);
            }
    
    public N endConfig(){
            return and();
    }
    public N and(){
            return (N) DockerImageFluentImpl.this.withConfig(builder.build());
    }

}
    public class ContainerConfigNestedImpl<N> extends DockerConfigFluentImpl<DockerImageFluent.ContainerConfigNested<N>> implements DockerImageFluent.ContainerConfigNested<N>,Nested<N>{

            private final DockerConfigBuilder builder;
    
            ContainerConfigNestedImpl(){
                    this.builder = new DockerConfigBuilder(this);
            }
            ContainerConfigNestedImpl(DockerConfig item){
                    this.builder = new DockerConfigBuilder(this, item);
            }
    
    public N endContainerConfig(){
            return and();
    }
    public N and(){
            return (N) DockerImageFluentImpl.this.withContainerConfig(builder.build());
    }

}


}
