package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public class SecretBuildSourceFluentImpl<A extends SecretBuildSourceFluent<A>> extends BaseFluent<A> implements SecretBuildSourceFluent<A>{

    private String destinationDir;
    private VisitableBuilder<? extends LocalObjectReference,?> secret;

    public SecretBuildSourceFluentImpl(){
    }
    public SecretBuildSourceFluentImpl(SecretBuildSource instance){
            this.withDestinationDir(instance.getDestinationDir()); 
            this.withSecret(instance.getSecret()); 
    }

    public String getDestinationDir(){
            return this.destinationDir;
    }

    public A withDestinationDir(String destinationDir){
            this.destinationDir=destinationDir; return (A) this;
    }

    public LocalObjectReference getSecret(){
            return this.secret!=null?this.secret.build():null;
    }

    public A withSecret(LocalObjectReference secret){
            if (secret!=null){ this.secret= new LocalObjectReferenceBuilder(secret); _visitables.add(this.secret);} return (A) this;
    }

    public SecretBuildSourceFluent.SecretNested<A> withNewSecret(){
            return new SecretNestedImpl();
    }

    public SecretBuildSourceFluent.SecretNested<A> withNewSecretLike(LocalObjectReference item){
            return new SecretNestedImpl(item);
    }

    public SecretBuildSourceFluent.SecretNested<A> editSecret(){
            return withNewSecretLike(getSecret());
    }

    public A withNewSecret(String name){
            return (A)withSecret(new LocalObjectReference(name));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SecretBuildSourceFluentImpl that = (SecretBuildSourceFluentImpl) o;
            if (destinationDir != null ? !destinationDir.equals(that.destinationDir) :that.destinationDir != null) return false;
            if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
            return true;
    }


    public class SecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretBuildSourceFluent.SecretNested<N>> implements SecretBuildSourceFluent.SecretNested<N>,Nested<N>{

            private final LocalObjectReferenceBuilder builder;
    
            SecretNestedImpl(){
                    this.builder = new LocalObjectReferenceBuilder(this);
            }
            SecretNestedImpl(LocalObjectReference item){
                    this.builder = new LocalObjectReferenceBuilder(this, item);
            }
    
    public N and(){
            return (N) SecretBuildSourceFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret(){
            return and();
    }

}


}
