package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectReference;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface TagImageHookFluent<A extends TagImageHookFluent<A>> extends Fluent<A>{


    public String getContainerName();
    public A withContainerName(String containerName);
    public ObjectReference getTo();
    public A withTo(ObjectReference to);
    public TagImageHookFluent.ToNested<A> withNewTo();
    public TagImageHookFluent.ToNested<A> withNewToLike(ObjectReference item);
    public TagImageHookFluent.ToNested<A> editTo();

    public interface ToNested<N> extends Nested<N>,ObjectReferenceFluent<TagImageHookFluent.ToNested<N>>{

        
    public N and();    public N endTo();
}


}
