package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class RBDVolumeSourceFluent<T extends RBDVolumeSourceFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String fsType;     String image;     String keyring;     List<String> monitors = new ArrayList();     String pool;     Boolean readOnly;     LocalObjectReference secretRef;     String user;     Map<String, Object> additionalProperties = new HashMap();

    public String getFsType(){
    return this.fsType;
    }
    public T withFsType( String fsType){
    this.fsType=fsType; return (T) this;
    }
    public String getImage(){
    return this.image;
    }
    public T withImage( String image){
    this.image=image; return (T) this;
    }
    public String getKeyring(){
    return this.keyring;
    }
    public T withKeyring( String keyring){
    this.keyring=keyring; return (T) this;
    }
    public T addToMonitors( String ...items){
    for (String item : items) {this.monitors.add(item);} return (T)this;
    }
    public List<String> getMonitors(){
    return this.monitors;
    }
    public T withMonitors( List<String> monitors){
    this.monitors.clear();if (monitors != null) {for (String item : monitors){this.addToMonitors(item);}} return (T) this;
    }
    public T withMonitors( String ...monitors){
    this.monitors.clear(); if (monitors != null) {for (String item :monitors){ this.addToMonitors(item);}} return (T) this;
    }
    public String getPool(){
    return this.pool;
    }
    public T withPool( String pool){
    this.pool=pool; return (T) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public T withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (T) this;
    }
    public LocalObjectReference getSecretRef(){
    return this.secretRef;
    }
    public T withSecretRef( LocalObjectReference secretRef){
    this.secretRef=secretRef; return (T) this;
    }
    public String getUser(){
    return this.user;
    }
    public T withUser( String user){
    this.user=user; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }



}
