package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ReplicationControllerStatusBuilder extends ReplicationControllerStatusFluent<ReplicationControllerStatusBuilder> implements VisitableBuilder<ReplicationControllerStatus,ReplicationControllerStatusBuilder>{

     ReplicationControllerStatusFluent<?> fluent;
public ReplicationControllerStatusBuilder(){
    this(new ReplicationControllerStatus());
}
public ReplicationControllerStatusBuilder( ReplicationControllerStatusFluent<?> fluent ){
    this(fluent, new ReplicationControllerStatus());
}
public ReplicationControllerStatusBuilder( ReplicationControllerStatusFluent<?> fluent , ReplicationControllerStatus instance ){
    this.fluent = fluent; fluent.withObservedGeneration(instance.getObservedGeneration()); fluent.withReplicas(instance.getReplicas()); 
}
public ReplicationControllerStatusBuilder( ReplicationControllerStatus instance ){
    this.fluent = this; this.withObservedGeneration(instance.getObservedGeneration()); this.withReplicas(instance.getReplicas()); 
}

public EditableReplicationControllerStatus build(){
    EditableReplicationControllerStatus buildable = new EditableReplicationControllerStatus(fluent.getObservedGeneration(),fluent.getReplicas());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    