package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class SecurityContextConstraintsBuilder extends SecurityContextConstraintsFluent<SecurityContextConstraintsBuilder> implements VisitableBuilder<SecurityContextConstraints,SecurityContextConstraintsBuilder>{

     SecurityContextConstraintsFluent<?> fluent;
public SecurityContextConstraintsBuilder(){
    this(new SecurityContextConstraints());
}
public SecurityContextConstraintsBuilder( SecurityContextConstraintsFluent<?> fluent ){
    this(fluent, new SecurityContextConstraints());
}
public SecurityContextConstraintsBuilder( SecurityContextConstraintsFluent<?> fluent , SecurityContextConstraints instance ){
    this.fluent = fluent; fluent.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); fluent.withAllowHostNetwork(instance.getAllowHostNetwork()); fluent.withAllowHostPorts(instance.getAllowHostPorts()); fluent.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); fluent.withAllowedCapabilities(instance.getAllowedCapabilities()); fluent.withApiVersion(instance.getApiVersion()); fluent.withGroups(instance.getGroups()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withRunAsUser(instance.getRunAsUser()); fluent.withSeLinuxContext(instance.getSeLinuxContext()); fluent.withUsers(instance.getUsers()); 
}
public SecurityContextConstraintsBuilder( SecurityContextConstraints instance ){
    this.fluent = this; this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); this.withAllowHostNetwork(instance.getAllowHostNetwork()); this.withAllowHostPorts(instance.getAllowHostPorts()); this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); this.withAllowedCapabilities(instance.getAllowedCapabilities()); this.withApiVersion(instance.getApiVersion()); this.withGroups(instance.getGroups()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRunAsUser(instance.getRunAsUser()); this.withSeLinuxContext(instance.getSeLinuxContext()); this.withUsers(instance.getUsers()); 
}

public EditableSecurityContextConstraints build(){
    EditableSecurityContextConstraints buildable = new EditableSecurityContextConstraints(fluent.isAllowHostDirVolumePlugin(),fluent.isAllowHostNetwork(),fluent.isAllowHostPorts(),fluent.isAllowPrivilegedContainer(),fluent.getAllowedCapabilities(),fluent.getApiVersion(),fluent.getGroups(),fluent.getKind(),fluent.getMetadata(),fluent.getRunAsUser(),fluent.getSeLinuxContext(),fluent.getUsers());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    