package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DeploymentConfigSpecBuilder extends DeploymentConfigSpecFluent<DeploymentConfigSpecBuilder> implements VisitableBuilder<DeploymentConfigSpec,DeploymentConfigSpecBuilder>{

     DeploymentConfigSpecFluent<?> fluent;
public DeploymentConfigSpecBuilder(){
    this(new DeploymentConfigSpec());
}
public DeploymentConfigSpecBuilder( DeploymentConfigSpecFluent<?> fluent ){
    this(fluent, new DeploymentConfigSpec());
}
public DeploymentConfigSpecBuilder( DeploymentConfigSpecFluent<?> fluent , DeploymentConfigSpec instance ){
    this.fluent = fluent; fluent.withReplicas(instance.getReplicas()); fluent.withSelector(instance.getSelector()); fluent.withStrategy(instance.getStrategy()); fluent.withTemplate(instance.getTemplate()); fluent.withTriggers(instance.getTriggers()); 
}
public DeploymentConfigSpecBuilder( DeploymentConfigSpec instance ){
    this.fluent = this; this.withReplicas(instance.getReplicas()); this.withSelector(instance.getSelector()); this.withStrategy(instance.getStrategy()); this.withTemplate(instance.getTemplate()); this.withTriggers(instance.getTriggers()); 
}

public EditableDeploymentConfigSpec build(){
    EditableDeploymentConfigSpec buildable = new EditableDeploymentConfigSpec(fluent.getReplicas(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate(),fluent.getTriggers());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    