
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "repository",
    "revision"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class GitRepoVolumeSource {

    /**
     * repository URL
     * 
     */
    @JsonProperty("repository")
    private String repository;
    /**
     * commit hash for the specified revision
     * 
     */
    @JsonProperty("revision")
    private String revision;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public GitRepoVolumeSource() {
    }

    /**
     * 
     * @param revision
     * @param repository
     */
    public GitRepoVolumeSource(String repository, String revision) {
        this.repository = repository;
        this.revision = revision;
    }

    /**
     * repository URL
     * 
     * @return
     *     The repository
     */
    @JsonProperty("repository")
    public String getRepository() {
        return repository;
    }

    /**
     * repository URL
     * 
     * @param repository
     *     The repository
     */
    @JsonProperty("repository")
    public void setRepository(String repository) {
        this.repository = repository;
    }

    /**
     * commit hash for the specified revision
     * 
     * @return
     *     The revision
     */
    @JsonProperty("revision")
    public String getRevision() {
        return revision;
    }

    /**
     * commit hash for the specified revision
     * 
     * @param revision
     *     The revision
     */
    @JsonProperty("revision")
    public void setRevision(String revision) {
        this.revision = revision;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
