
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "path",
    "readOnly",
    "server"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class NFSVolumeSource {

    /**
     * the path that is exported by the NFS server; see http://releases.k8s.io/v1.0.0/docs/volumes.md#nfs
     * 
     */
    @JsonProperty("path")
    private String path;
    /**
     * forces the NFS export to be mounted with read-only permissions; see http://releases.k8s.io/v1.0.0/docs/volumes.md#nfs
     * 
     */
    @JsonProperty("readOnly")
    private Boolean readOnly;
    /**
     * the hostname or IP address of the NFS server; see http://releases.k8s.io/v1.0.0/docs/volumes.md#nfs
     * 
     */
    @JsonProperty("server")
    private String server;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public NFSVolumeSource() {
    }

    /**
     * 
     * @param readOnly
     * @param path
     * @param server
     */
    public NFSVolumeSource(String path, Boolean readOnly, String server) {
        this.path = path;
        this.readOnly = readOnly;
        this.server = server;
    }

    /**
     * the path that is exported by the NFS server; see http://releases.k8s.io/v1.0.0/docs/volumes.md#nfs
     * 
     * @return
     *     The path
     */
    @JsonProperty("path")
    public String getPath() {
        return path;
    }

    /**
     * the path that is exported by the NFS server; see http://releases.k8s.io/v1.0.0/docs/volumes.md#nfs
     * 
     * @param path
     *     The path
     */
    @JsonProperty("path")
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * forces the NFS export to be mounted with read-only permissions; see http://releases.k8s.io/v1.0.0/docs/volumes.md#nfs
     * 
     * @return
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public Boolean getReadOnly() {
        return readOnly;
    }

    /**
     * forces the NFS export to be mounted with read-only permissions; see http://releases.k8s.io/v1.0.0/docs/volumes.md#nfs
     * 
     * @param readOnly
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    /**
     * the hostname or IP address of the NFS server; see http://releases.k8s.io/v1.0.0/docs/volumes.md#nfs
     * 
     * @return
     *     The server
     */
    @JsonProperty("server")
    public String getServer() {
        return server;
    }

    /**
     * the hostname or IP address of the NFS server; see http://releases.k8s.io/v1.0.0/docs/volumes.md#nfs
     * 
     * @param server
     *     The server
     */
    @JsonProperty("server")
    public void setServer(String server) {
        this.server = server;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
