package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DockerBuildStrategyBuilder extends DockerBuildStrategyFluent<DockerBuildStrategyBuilder> implements VisitableBuilder<DockerBuildStrategy,DockerBuildStrategyBuilder>{

     DockerBuildStrategyFluent<?> fluent;
public DockerBuildStrategyBuilder(){
    this(new DockerBuildStrategy());
}
public DockerBuildStrategyBuilder( DockerBuildStrategyFluent<?> fluent ){
    this(fluent, new DockerBuildStrategy());
}
public DockerBuildStrategyBuilder( DockerBuildStrategyFluent<?> fluent , DockerBuildStrategy instance ){
    this.fluent = fluent; fluent.withEnv(instance.getEnv()); fluent.withForcePull(instance.getForcePull()); fluent.withFrom(instance.getFrom()); fluent.withNoCache(instance.getNoCache()); fluent.withPullSecret(instance.getPullSecret()); 
}
public DockerBuildStrategyBuilder( DockerBuildStrategy instance ){
    this.fluent = this; this.withEnv(instance.getEnv()); this.withForcePull(instance.getForcePull()); this.withFrom(instance.getFrom()); this.withNoCache(instance.getNoCache()); this.withPullSecret(instance.getPullSecret()); 
}

public EditableDockerBuildStrategy build(){
    EditableDockerBuildStrategy buildable = new EditableDockerBuildStrategy(fluent.getEnv(),fluent.isForcePull(),fluent.getFrom(),fluent.isNoCache(),fluent.getPullSecret());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    