package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class NamedTagEventListBuilder extends NamedTagEventListFluent<NamedTagEventListBuilder> implements VisitableBuilder<NamedTagEventList,NamedTagEventListBuilder>{

     NamedTagEventListFluent<?> fluent;
public NamedTagEventListBuilder(){
    this(new NamedTagEventList());
}
public NamedTagEventListBuilder( NamedTagEventListFluent<?> fluent ){
    this(fluent, new NamedTagEventList());
}
public NamedTagEventListBuilder( NamedTagEventListFluent<?> fluent , NamedTagEventList instance ){
    this.fluent = fluent; fluent.withItems(instance.getItems()); fluent.withTag(instance.getTag()); 
}
public NamedTagEventListBuilder( NamedTagEventList instance ){
    this.fluent = this; this.withItems(instance.getItems()); this.withTag(instance.getTag()); 
}

public EditableNamedTagEventList build(){
    EditableNamedTagEventList buildable = new EditableNamedTagEventList(fluent.getItems(),fluent.getTag());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    