/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptions;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityContextConstraintsFluent<T extends SecurityContextConstraintsFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Boolean allowHostDirVolumePlugin;
    Boolean allowHostNetwork;
    Boolean allowHostPorts;
    Boolean allowPrivilegedContainer;
    List<String> allowedCapabilities = new ArrayList<String>();
    SecurityContextConstraints.ApiVersion apiVersion;
    List<String> groups = new ArrayList<String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    RunAsUserStrategyOptions runAsUser;
    SELinuxContextStrategyOptions seLinuxContext;
    List<String> users = new ArrayList<String>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Boolean isAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    public T withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        return (T)this;
    }

    public Boolean isAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    public T withAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
        return (T)this;
    }

    public Boolean isAllowHostPorts() {
        return this.allowHostPorts;
    }

    public T withAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
        return (T)this;
    }

    public Boolean isAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    public T withAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        return (T)this;
    }

    public T addToAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (T)this;
    }

    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    public T withAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (T)this;
    }

    public T withAllowedCapabilities(String ... allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (T)this;
    }

    public SecurityContextConstraints.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(SecurityContextConstraints.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (T)this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public T withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    public T withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser;
    }

    public T withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        this.runAsUser = runAsUser;
        return (T)this;
    }

    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return this.seLinuxContext;
    }

    public T withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        this.seLinuxContext = seLinuxContext;
        return (T)this;
    }

    public T addToUsers(String ... items) {
        for (String item : items) {
            this.users.add(item);
        }
        return (T)this;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public T withUsers(List<String> users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    public T withUsers(String ... users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.withMetadata(this.builder.build());
        }
    }
}

