package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ConfigFluent<A extends ConfigFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToClusters(NamedCluster... items);
    public A removeFromClusters(NamedCluster... items);
    public List<NamedCluster> getClusters();
    public A withClusters(List<NamedCluster> clusters);
    public A withClusters(NamedCluster... clusters);
    public ConfigFluent.ClustersNested<A> addNewCluster();
    public ConfigFluent.ClustersNested<A> addNewClusterLike(NamedCluster item);
    public A addToContexts(NamedContext... items);
    public A removeFromContexts(NamedContext... items);
    public List<NamedContext> getContexts();
    public A withContexts(List<NamedContext> contexts);
    public A withContexts(NamedContext... contexts);
    public ConfigFluent.ContextsNested<A> addNewContext();
    public ConfigFluent.ContextsNested<A> addNewContextLike(NamedContext item);
    public String getCurrentContext();
    public A withCurrentContext(String currentContext);
    public A addToExtensions(NamedExtension... items);
    public A removeFromExtensions(NamedExtension... items);
    public List<NamedExtension> getExtensions();
    public A withExtensions(List<NamedExtension> extensions);
    public A withExtensions(NamedExtension... extensions);
    public ConfigFluent.ExtensionsNested<A> addNewExtension();
    public ConfigFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);
    public String getKind();
    public A withKind(String kind);
    public Preferences getPreferences();
    public A withPreferences(Preferences preferences);
    public ConfigFluent.PreferencesNested<A> withNewPreferences();
    public ConfigFluent.PreferencesNested<A> withNewPreferencesLike(Preferences item);
    public ConfigFluent.PreferencesNested<A> editPreferences();
    public ConfigFluent.PreferencesNested<A> editOrNewPreferences();
    public ConfigFluent.PreferencesNested<A> editOrNewPreferencesLike(Preferences item);
    public A addToUsers(NamedAuthInfo... items);
    public A removeFromUsers(NamedAuthInfo... items);
    public List<NamedAuthInfo> getUsers();
    public A withUsers(List<NamedAuthInfo> users);
    public A withUsers(NamedAuthInfo... users);
    public ConfigFluent.UsersNested<A> addNewUser();
    public ConfigFluent.UsersNested<A> addNewUserLike(NamedAuthInfo item);

    public interface ClustersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedClusterFluent<ConfigFluent.ClustersNested<N>>{

        
    public N and();    public N endCluster();
}
    public interface ContextsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedContextFluent<ConfigFluent.ContextsNested<N>>{

        
    public N and();    public N endContext();
}
    public interface ExtensionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedExtensionFluent<ConfigFluent.ExtensionsNested<N>>{

        
    public N and();    public N endExtension();
}
    public interface PreferencesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PreferencesFluent<ConfigFluent.PreferencesNested<N>>{

        
    public N and();    public N endPreferences();
}
    public interface UsersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedAuthInfoFluent<ConfigFluent.UsersNested<N>>{

        
    public N and();    public N endUser();
}


}
