package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import io.sundr.builder.annotations.Buildable;
import com.fasterxml.jackson.core.JsonParser;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class HTTPGetActionFluentImpl<A extends HTTPGetActionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTTPGetActionFluent<A>{

    private String host;
    private List<VisitableBuilder<? extends HTTPHeader,?>> httpHeaders =  new ArrayList<VisitableBuilder<? extends HTTPHeader,?>>();
    private String path;
    private VisitableBuilder<? extends IntOrString,?> port;
    private String scheme;

    public HTTPGetActionFluentImpl(){
    }
    public HTTPGetActionFluentImpl(HTTPGetAction instance){
            this.withHost(instance.getHost()); 
            this.withHttpHeaders(instance.getHttpHeaders()); 
            this.withPath(instance.getPath()); 
            this.withPort(instance.getPort()); 
            this.withScheme(instance.getScheme()); 
    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public A addToHttpHeaders(HTTPHeader... items){
            for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.add(builder);this.httpHeaders.add(builder);} return (A)this;
    }

    public A removeFromHttpHeaders(HTTPHeader... items){
            for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.remove(builder);this.httpHeaders.remove(builder);} return (A)this;
    }

    public List<HTTPHeader> getHttpHeaders(){
            return build(httpHeaders);
    }

    public A withHttpHeaders(List<HTTPHeader> httpHeaders){
            _visitables.removeAll(this.httpHeaders);
            this.httpHeaders.clear();
            if (httpHeaders != null) {for (HTTPHeader item : httpHeaders){this.addToHttpHeaders(item);}} return (A) this;
    }

    public A withHttpHeaders(HTTPHeader... httpHeaders){
            this.httpHeaders.clear(); if (httpHeaders != null) {for (HTTPHeader item :httpHeaders){ this.addToHttpHeaders(item);}} return (A) this;
    }

    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader(){
            return new HttpHeadersNestedImpl();
    }

    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item){
            return new HttpHeadersNestedImpl(item);
    }

    public A addNewHttpHeader(String name,String value){
            return (A)addToHttpHeaders(new HTTPHeader(name, value));
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public IntOrString getPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(IntOrString port){
            _visitables.remove(this.port);
            if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.add(this.port);} return (A) this;
    }

    public HTTPGetActionFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public HTTPGetActionFluent.PortNested<A> withNewPortLike(IntOrString item){
            return new PortNestedImpl(item);
    }

    public HTTPGetActionFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public HTTPGetActionFluent.PortNested<A> editOrNewPort(){
            return withNewPortLike(getPort() != null ? getPort(): new IntOrStringBuilder().build());
    }

    public HTTPGetActionFluent.PortNested<A> editOrNewPortLike(IntOrString item){
            return withNewPortLike(getPort() != null ? getPort(): item);
    }

    public A withNewPort(Integer intVal){
            return (A)withPort(new IntOrString(intVal));
    }

    public A withNewPort(String strVal){
            return (A)withPort(new IntOrString(strVal));
    }

    public String getScheme(){
            return this.scheme;
    }

    public A withScheme(String scheme){
            this.scheme=scheme; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPGetActionFluentImpl that = (HTTPGetActionFluentImpl) o;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (httpHeaders != null ? !httpHeaders.equals(that.httpHeaders) :that.httpHeaders != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
            return true;
    }


    public class HttpHeadersNestedImpl<N> extends HTTPHeaderFluentImpl<HTTPGetActionFluent.HttpHeadersNested<N>> implements HTTPGetActionFluent.HttpHeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HTTPHeaderBuilder builder;
    
            HttpHeadersNestedImpl(HTTPHeader item){
                    this.builder = new HTTPHeaderBuilder(this, item);
            }
            HttpHeadersNestedImpl(){
                    this.builder = new HTTPHeaderBuilder(this);
            }
    
    public N and(){
            return (N) HTTPGetActionFluentImpl.this.addToHttpHeaders(builder.build());
    }
    public N endHttpHeader(){
            return and();
    }

}
    public class PortNestedImpl<N> extends IntOrStringFluentImpl<HTTPGetActionFluent.PortNested<N>> implements HTTPGetActionFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IntOrStringBuilder builder;
    
            PortNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
            PortNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
    
    public N and(){
            return (N) HTTPGetActionFluentImpl.this.withPort(builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
