package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class LifecycleBuilder extends LifecycleFluentImpl<LifecycleBuilder> implements VisitableBuilder<Lifecycle,LifecycleBuilder>{

    LifecycleFluent<?> fluent;
    Boolean validationEnabled;

    public LifecycleBuilder(){
            this(true);
    }
    public LifecycleBuilder(Boolean validationEnabled){
            this(new Lifecycle(), validationEnabled);
    }
    public LifecycleBuilder(LifecycleFluent<?> fluent){
            this(fluent, true);
    }
    public LifecycleBuilder(LifecycleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Lifecycle(), validationEnabled);
    }
    public LifecycleBuilder(LifecycleFluent<?> fluent,Lifecycle instance){
            this(fluent, instance, true);
    }
    public LifecycleBuilder(LifecycleFluent<?> fluent,Lifecycle instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPostStart(instance.getPostStart()); 
            fluent.withPreStop(instance.getPreStop()); 
            this.validationEnabled = validationEnabled; 
    }
    public LifecycleBuilder(Lifecycle instance){
            this(instance,true);
    }
    public LifecycleBuilder(Lifecycle instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPostStart(instance.getPostStart()); 
            this.withPreStop(instance.getPreStop()); 
            this.validationEnabled = validationEnabled; 
    }

    public Lifecycle build(){
            Lifecycle buildable = new Lifecycle(fluent.getPostStart(),fluent.getPreStop());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LifecycleBuilder that = (LifecycleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
