package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class LoadBalancerIngressBuilder extends LoadBalancerIngressFluentImpl<LoadBalancerIngressBuilder> implements VisitableBuilder<LoadBalancerIngress,LoadBalancerIngressBuilder>{

    LoadBalancerIngressFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerIngressBuilder(){
            this(true);
    }
    public LoadBalancerIngressBuilder(Boolean validationEnabled){
            this(new LoadBalancerIngress(), validationEnabled);
    }
    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent){
            this(fluent, true);
    }
    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LoadBalancerIngress(), validationEnabled);
    }
    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,LoadBalancerIngress instance){
            this(fluent, instance, true);
    }
    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,LoadBalancerIngress instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHostname(instance.getHostname()); 
            fluent.withIp(instance.getIp()); 
            this.validationEnabled = validationEnabled; 
    }
    public LoadBalancerIngressBuilder(LoadBalancerIngress instance){
            this(instance,true);
    }
    public LoadBalancerIngressBuilder(LoadBalancerIngress instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHostname(instance.getHostname()); 
            this.withIp(instance.getIp()); 
            this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerIngress build(){
            LoadBalancerIngress buildable = new LoadBalancerIngress(fluent.getHostname(),fluent.getIp());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LoadBalancerIngressBuilder that = (LoadBalancerIngressBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
