package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class NamedContextBuilder extends NamedContextFluentImpl<NamedContextBuilder> implements VisitableBuilder<NamedContext,NamedContextBuilder>{

    NamedContextFluent<?> fluent;
    Boolean validationEnabled;

    public NamedContextBuilder(){
            this(true);
    }
    public NamedContextBuilder(Boolean validationEnabled){
            this(new NamedContext(), validationEnabled);
    }
    public NamedContextBuilder(NamedContextFluent<?> fluent){
            this(fluent, true);
    }
    public NamedContextBuilder(NamedContextFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NamedContext(), validationEnabled);
    }
    public NamedContextBuilder(NamedContextFluent<?> fluent,NamedContext instance){
            this(fluent, instance, true);
    }
    public NamedContextBuilder(NamedContextFluent<?> fluent,NamedContext instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContext(instance.getContext()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamedContextBuilder(NamedContext instance){
            this(instance,true);
    }
    public NamedContextBuilder(NamedContext instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContext(instance.getContext()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public NamedContext build(){
            NamedContext buildable = new NamedContext(fluent.getContext(),fluent.getName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedContextBuilder that = (NamedContextBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
