package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface NodeStatusFluent<A extends NodeStatusFluent<A>> extends Fluent<A>{


    public A addToAddresses(NodeAddress... items);
    public A removeFromAddresses(NodeAddress... items);
    public List<NodeAddress> getAddresses();
    public A withAddresses(List<NodeAddress> addresses);
    public A withAddresses(NodeAddress... addresses);
    public NodeStatusFluent.AddressesNested<A> addNewAddress();
    public NodeStatusFluent.AddressesNested<A> addNewAddressLike(NodeAddress item);
    public A addNewAddress(String address,String type);
    public A addToAllocatable(String key,Quantity value);
    public A addToAllocatable(Map<String,Quantity> map);
    public A removeFromAllocatable(String key);
    public A removeFromAllocatable(Map<String,Quantity> map);
    public Map<String,Quantity> getAllocatable();
    public A withAllocatable(Map<String,Quantity> allocatable);
    public A addToCapacity(String key,Quantity value);
    public A addToCapacity(Map<String,Quantity> map);
    public A removeFromCapacity(String key);
    public A removeFromCapacity(Map<String,Quantity> map);
    public Map<String,Quantity> getCapacity();
    public A withCapacity(Map<String,Quantity> capacity);
    public A addToConditions(NodeCondition... items);
    public A removeFromConditions(NodeCondition... items);
    public List<NodeCondition> getConditions();
    public A withConditions(List<NodeCondition> conditions);
    public A withConditions(NodeCondition... conditions);
    public NodeStatusFluent.ConditionsNested<A> addNewCondition();
    public NodeStatusFluent.ConditionsNested<A> addNewConditionLike(NodeCondition item);
    public NodeDaemonEndpoints getDaemonEndpoints();
    public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints);
    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints();
    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item);
    public NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints();
    public NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpoints();
    public NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(NodeDaemonEndpoints item);
    public A addToImages(ContainerImage... items);
    public A removeFromImages(ContainerImage... items);
    public List<ContainerImage> getImages();
    public A withImages(List<ContainerImage> images);
    public A withImages(ContainerImage... images);
    public NodeStatusFluent.ImagesNested<A> addNewImage();
    public NodeStatusFluent.ImagesNested<A> addNewImageLike(ContainerImage item);
    public NodeSystemInfo getNodeInfo();
    public A withNodeInfo(NodeSystemInfo nodeInfo);
    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo();
    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item);
    public NodeStatusFluent.NodeInfoNested<A> editNodeInfo();
    public NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfo();
    public NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item);
    public String getPhase();
    public A withPhase(String phase);
    public A addToVolumesAttached(AttachedVolume... items);
    public A removeFromVolumesAttached(AttachedVolume... items);
    public List<AttachedVolume> getVolumesAttached();
    public A withVolumesAttached(List<AttachedVolume> volumesAttached);
    public A withVolumesAttached(AttachedVolume... volumesAttached);
    public NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttached();
    public NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttachedLike(AttachedVolume item);
    public A addNewVolumesAttached(String devicePath,String name);
    public A addToVolumesInUse(String... items);
    public A removeFromVolumesInUse(String... items);
    public List<String> getVolumesInUse();
    public A withVolumesInUse(List<String> volumesInUse);
    public A withVolumesInUse(String... volumesInUse);

    public interface AddressesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeAddressFluent<NodeStatusFluent.AddressesNested<N>>{

        
    public N and();    public N endAddress();
}
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeConditionFluent<NodeStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface DaemonEndpointsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeDaemonEndpointsFluent<NodeStatusFluent.DaemonEndpointsNested<N>>{

        
    public N and();    public N endDaemonEndpoints();
}
    public interface ImagesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerImageFluent<NodeStatusFluent.ImagesNested<N>>{

        
    public N and();    public N endImage();
}
    public interface NodeInfoNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeSystemInfoFluent<NodeStatusFluent.NodeInfoNested<N>>{

        
    public N and();    public N endNodeInfo();
}
    public interface VolumesAttachedNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AttachedVolumeFluent<NodeStatusFluent.VolumesAttachedNested<N>>{

        
    public N and();    public N endVolumesAttached();
}


}
