package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class PatchBuilder extends PatchFluentImpl<PatchBuilder> implements VisitableBuilder<Patch,PatchBuilder>{

    PatchFluent<?> fluent;
    Boolean validationEnabled;

    public PatchBuilder(){
            this(true);
    }
    public PatchBuilder(Boolean validationEnabled){
            this(new Patch(), validationEnabled);
    }
    public PatchBuilder(PatchFluent<?> fluent){
            this(fluent, true);
    }
    public PatchBuilder(PatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Patch(), validationEnabled);
    }
    public PatchBuilder(PatchFluent<?> fluent,Patch instance){
            this(fluent, instance, true);
    }
    public PatchBuilder(PatchFluent<?> fluent,Patch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public PatchBuilder(Patch instance){
            this(instance,true);
    }
    public PatchBuilder(Patch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public Patch build(){
            Patch buildable = new Patch();
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PatchBuilder that = (PatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
