package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface PodListFluent<A extends PodListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Pod... items);
    public A removeFromItems(Pod... items);
    public List<Pod> getItems();
    public A withItems(List<Pod> items);
    public A withItems(Pod... items);
    public PodListFluent.ItemsNested<A> addNewItem();
    public PodListFluent.ItemsNested<A> addNewItemLike(Pod item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PodListFluent.MetadataNested<A> withNewMetadata();
    public PodListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PodListFluent.MetadataNested<A> editMetadata();
    public PodListFluent.MetadataNested<A> editOrNewMetadata();
    public PodListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodFluent<PodListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<PodListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
