package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class PodSpecBuilder extends PodSpecFluentImpl<PodSpecBuilder> implements VisitableBuilder<PodSpec,PodSpecBuilder>{

    PodSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PodSpecBuilder(){
            this(true);
    }
    public PodSpecBuilder(Boolean validationEnabled){
            this(new PodSpec(), validationEnabled);
    }
    public PodSpecBuilder(PodSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PodSpecBuilder(PodSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PodSpec(), validationEnabled);
    }
    public PodSpecBuilder(PodSpecFluent<?> fluent,PodSpec instance){
            this(fluent, instance, true);
    }
    public PodSpecBuilder(PodSpecFluent<?> fluent,PodSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
            fluent.withContainers(instance.getContainers()); 
            fluent.withDnsPolicy(instance.getDnsPolicy()); 
            fluent.withHost(instance.getHost()); 
            fluent.withHostIPC(instance.getHostIPC()); 
            fluent.withHostNetwork(instance.getHostNetwork()); 
            fluent.withHostPID(instance.getHostPID()); 
            fluent.withHostname(instance.getHostname()); 
            fluent.withImagePullSecrets(instance.getImagePullSecrets()); 
            fluent.withNodeName(instance.getNodeName()); 
            fluent.withNodeSelector(instance.getNodeSelector()); 
            fluent.withRestartPolicy(instance.getRestartPolicy()); 
            fluent.withSecurityContext(instance.getSecurityContext()); 
            fluent.withServiceAccount(instance.getServiceAccount()); 
            fluent.withServiceAccountName(instance.getServiceAccountName()); 
            fluent.withSubdomain(instance.getSubdomain()); 
            fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
            fluent.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }
    public PodSpecBuilder(PodSpec instance){
            this(instance,true);
    }
    public PodSpecBuilder(PodSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
            this.withContainers(instance.getContainers()); 
            this.withDnsPolicy(instance.getDnsPolicy()); 
            this.withHost(instance.getHost()); 
            this.withHostIPC(instance.getHostIPC()); 
            this.withHostNetwork(instance.getHostNetwork()); 
            this.withHostPID(instance.getHostPID()); 
            this.withHostname(instance.getHostname()); 
            this.withImagePullSecrets(instance.getImagePullSecrets()); 
            this.withNodeName(instance.getNodeName()); 
            this.withNodeSelector(instance.getNodeSelector()); 
            this.withRestartPolicy(instance.getRestartPolicy()); 
            this.withSecurityContext(instance.getSecurityContext()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withSubdomain(instance.getSubdomain()); 
            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
            this.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }

    public PodSpec build(){
            PodSpec buildable = new PodSpec(fluent.getActiveDeadlineSeconds(),fluent.getContainers(),fluent.getDnsPolicy(),fluent.getHost(),fluent.isHostIPC(),fluent.isHostNetwork(),fluent.isHostPID(),fluent.getHostname(),fluent.getImagePullSecrets(),fluent.getNodeName(),fluent.getNodeSelector(),fluent.getRestartPolicy(),fluent.getSecurityContext(),fluent.getServiceAccount(),fluent.getServiceAccountName(),fluent.getSubdomain(),fluent.getTerminationGracePeriodSeconds(),fluent.getVolumes());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodSpecBuilder that = (PodSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
