package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ReplicationControllerSpecBuilder extends ReplicationControllerSpecFluentImpl<ReplicationControllerSpecBuilder> implements VisitableBuilder<ReplicationControllerSpec,ReplicationControllerSpecBuilder>{

    ReplicationControllerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicationControllerSpecBuilder(){
            this(true);
    }
    public ReplicationControllerSpecBuilder(Boolean validationEnabled){
            this(new ReplicationControllerSpec(), validationEnabled);
    }
    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReplicationControllerSpec(), validationEnabled);
    }
    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent,ReplicationControllerSpec instance){
            this(fluent, instance, true);
    }
    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent,ReplicationControllerSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas()); 
            fluent.withSelector(instance.getSelector()); 
            fluent.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReplicationControllerSpecBuilder(ReplicationControllerSpec instance){
            this(instance,true);
    }
    public ReplicationControllerSpecBuilder(ReplicationControllerSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas()); 
            this.withSelector(instance.getSelector()); 
            this.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }

    public ReplicationControllerSpec build(){
            ReplicationControllerSpec buildable = new ReplicationControllerSpec(fluent.getReplicas(),fluent.getSelector(),fluent.getTemplate());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReplicationControllerSpecBuilder that = (ReplicationControllerSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
