package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class RootPathsBuilder extends RootPathsFluentImpl<RootPathsBuilder> implements VisitableBuilder<RootPaths,RootPathsBuilder>{

    RootPathsFluent<?> fluent;
    Boolean validationEnabled;

    public RootPathsBuilder(){
            this(true);
    }
    public RootPathsBuilder(Boolean validationEnabled){
            this(new RootPaths(), validationEnabled);
    }
    public RootPathsBuilder(RootPathsFluent<?> fluent){
            this(fluent, true);
    }
    public RootPathsBuilder(RootPathsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RootPaths(), validationEnabled);
    }
    public RootPathsBuilder(RootPathsFluent<?> fluent,RootPaths instance){
            this(fluent, instance, true);
    }
    public RootPathsBuilder(RootPathsFluent<?> fluent,RootPaths instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPaths(instance.getPaths()); 
            this.validationEnabled = validationEnabled; 
    }
    public RootPathsBuilder(RootPaths instance){
            this(instance,true);
    }
    public RootPathsBuilder(RootPaths instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPaths(instance.getPaths()); 
            this.validationEnabled = validationEnabled; 
    }

    public RootPaths build(){
            RootPaths buildable = new RootPaths(fluent.getPaths());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RootPathsBuilder that = (RootPathsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
