package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class SecurityContextConstraintsBuilder extends SecurityContextConstraintsFluentImpl<SecurityContextConstraintsBuilder> implements VisitableBuilder<SecurityContextConstraints,SecurityContextConstraintsBuilder>{

    SecurityContextConstraintsFluent<?> fluent;
    Boolean validationEnabled;

    public SecurityContextConstraintsBuilder(){
            this(true);
    }
    public SecurityContextConstraintsBuilder(Boolean validationEnabled){
            this(new SecurityContextConstraints(), validationEnabled);
    }
    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent){
            this(fluent, true);
    }
    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SecurityContextConstraints(), validationEnabled);
    }
    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent,SecurityContextConstraints instance){
            this(fluent, instance, true);
    }
    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent,SecurityContextConstraints instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); 
            fluent.withAllowHostIPC(instance.getAllowHostIPC()); 
            fluent.withAllowHostNetwork(instance.getAllowHostNetwork()); 
            fluent.withAllowHostPID(instance.getAllowHostPID()); 
            fluent.withAllowHostPorts(instance.getAllowHostPorts()); 
            fluent.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); 
            fluent.withAllowedCapabilities(instance.getAllowedCapabilities()); 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
            fluent.withFsGroup(instance.getFsGroup()); 
            fluent.withGroups(instance.getGroups()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withPriority(instance.getPriority()); 
            fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
            fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
            fluent.withRunAsUser(instance.getRunAsUser()); 
            fluent.withSeLinuxContext(instance.getSeLinuxContext()); 
            fluent.withSeccompProfiles(instance.getSeccompProfiles()); 
            fluent.withSupplementalGroups(instance.getSupplementalGroups()); 
            fluent.withUsers(instance.getUsers()); 
            fluent.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }
    public SecurityContextConstraintsBuilder(SecurityContextConstraints instance){
            this(instance,true);
    }
    public SecurityContextConstraintsBuilder(SecurityContextConstraints instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); 
            this.withAllowHostIPC(instance.getAllowHostIPC()); 
            this.withAllowHostNetwork(instance.getAllowHostNetwork()); 
            this.withAllowHostPID(instance.getAllowHostPID()); 
            this.withAllowHostPorts(instance.getAllowHostPorts()); 
            this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); 
            this.withAllowedCapabilities(instance.getAllowedCapabilities()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
            this.withFsGroup(instance.getFsGroup()); 
            this.withGroups(instance.getGroups()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withPriority(instance.getPriority()); 
            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
            this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
            this.withRunAsUser(instance.getRunAsUser()); 
            this.withSeLinuxContext(instance.getSeLinuxContext()); 
            this.withSeccompProfiles(instance.getSeccompProfiles()); 
            this.withSupplementalGroups(instance.getSupplementalGroups()); 
            this.withUsers(instance.getUsers()); 
            this.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }

    public SecurityContextConstraints build(){
            SecurityContextConstraints buildable = new SecurityContextConstraints(fluent.isAllowHostDirVolumePlugin(),fluent.isAllowHostIPC(),fluent.isAllowHostNetwork(),fluent.isAllowHostPID(),fluent.isAllowHostPorts(),fluent.isAllowPrivilegedContainer(),fluent.getAllowedCapabilities(),fluent.getApiVersion(),fluent.getDefaultAddCapabilities(),fluent.getFsGroup(),fluent.getGroups(),fluent.getKind(),fluent.getMetadata(),fluent.getPriority(),fluent.isReadOnlyRootFilesystem(),fluent.getRequiredDropCapabilities(),fluent.getRunAsUser(),fluent.getSeLinuxContext(),fluent.getSeccompProfiles(),fluent.getSupplementalGroups(),fluent.getUsers(),fluent.getVolumes());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SecurityContextConstraintsBuilder that = (SecurityContextConstraintsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
