package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface ServiceSpecFluent<A extends ServiceSpecFluent<A>> extends Fluent<A>{


    public String getClusterIP();
    public A withClusterIP(String clusterIP);
    public A addToDeprecatedPublicIPs(String... items);
    public A removeFromDeprecatedPublicIPs(String... items);
    public List<String> getDeprecatedPublicIPs();
    public A withDeprecatedPublicIPs(List<String> deprecatedPublicIPs);
    public A withDeprecatedPublicIPs(String... deprecatedPublicIPs);
    public A addToExternalIPs(String... items);
    public A removeFromExternalIPs(String... items);
    public List<String> getExternalIPs();
    public A withExternalIPs(List<String> externalIPs);
    public A withExternalIPs(String... externalIPs);
    public String getLoadBalancerIP();
    public A withLoadBalancerIP(String loadBalancerIP);
    public A addToLoadBalancerSourceRanges(String... items);
    public A removeFromLoadBalancerSourceRanges(String... items);
    public List<String> getLoadBalancerSourceRanges();
    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges);
    public A withLoadBalancerSourceRanges(String... loadBalancerSourceRanges);
    public String getPortalIP();
    public A withPortalIP(String portalIP);
    public A addToPorts(ServicePort... items);
    public A removeFromPorts(ServicePort... items);
    public List<ServicePort> getPorts();
    public A withPorts(List<ServicePort> ports);
    public A withPorts(ServicePort... ports);
    public ServiceSpecFluent.PortsNested<A> addNewPort();
    public ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item);
    public A addToSelector(String key,String value);
    public A addToSelector(Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(Map<String,String> map);
    public Map<String,String> getSelector();
    public A withSelector(Map<String,String> selector);
    public String getSessionAffinity();
    public A withSessionAffinity(String sessionAffinity);
    public String getType();
    public A withType(String type);

    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServicePortFluent<ServiceSpecFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}


}
