package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class DaemonSetStatusBuilder extends DaemonSetStatusFluentImpl<DaemonSetStatusBuilder> implements VisitableBuilder<DaemonSetStatus,DaemonSetStatusBuilder>{

    DaemonSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DaemonSetStatusBuilder(){
            this(true);
    }
    public DaemonSetStatusBuilder(Boolean validationEnabled){
            this(new DaemonSetStatus(), validationEnabled);
    }
    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent){
            this(fluent, true);
    }
    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DaemonSetStatus(), validationEnabled);
    }
    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent,DaemonSetStatus instance){
            this(fluent, instance, true);
    }
    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent,DaemonSetStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); 
            fluent.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); 
            fluent.withNumberMisscheduled(instance.getNumberMisscheduled()); 
            this.validationEnabled = validationEnabled; 
    }
    public DaemonSetStatusBuilder(DaemonSetStatus instance){
            this(instance,true);
    }
    public DaemonSetStatusBuilder(DaemonSetStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); 
            this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); 
            this.withNumberMisscheduled(instance.getNumberMisscheduled()); 
            this.validationEnabled = validationEnabled; 
    }

    public DaemonSetStatus build(){
            DaemonSetStatus buildable = new DaemonSetStatus(fluent.getCurrentNumberScheduled(),fluent.getDesiredNumberScheduled(),fluent.getNumberMisscheduled());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonSetStatusBuilder that = (DaemonSetStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
