package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class HTTPIngressPathBuilder extends HTTPIngressPathFluentImpl<HTTPIngressPathBuilder> implements VisitableBuilder<HTTPIngressPath,HTTPIngressPathBuilder>{

    HTTPIngressPathFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPIngressPathBuilder(){
            this(true);
    }
    public HTTPIngressPathBuilder(Boolean validationEnabled){
            this(new HTTPIngressPath(), validationEnabled);
    }
    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPIngressPath(), validationEnabled);
    }
    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent,HTTPIngressPath instance){
            this(fluent, instance, true);
    }
    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent,HTTPIngressPath instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBackend(instance.getBackend()); 
            fluent.withPath(instance.getPath()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPIngressPathBuilder(HTTPIngressPath instance){
            this(instance,true);
    }
    public HTTPIngressPathBuilder(HTTPIngressPath instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBackend(instance.getBackend()); 
            this.withPath(instance.getPath()); 
            this.validationEnabled = validationEnabled; 
    }

    public HTTPIngressPath build(){
            HTTPIngressPath buildable = new HTTPIngressPath(fluent.getBackend(),fluent.getPath());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPIngressPathBuilder that = (HTTPIngressPathBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
